/*
 * Decompiled with CFR 0.152.
 */
package cn.shellming.thrift.client.cache;

import cn.shellming.thrift.client.cache.ThriftServiceMethodCache;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;

public class ThriftServiceMethodCacheManager {
    private static final Map<String, ThriftServiceMethodCache> methodCachedMap = Maps.newConcurrentMap();

    private ThriftServiceMethodCacheManager() {
    }

    public static Method getMethod(Class<?> targetClass, String methodName, Class<?> ... arguments) throws NoSuchMethodException {
        ThriftServiceMethodCache methodCache = ThriftServiceMethodCacheManager.putIfAbsent(targetClass);
        return methodCache.getMethod(methodName, arguments);
    }

    public static void put(Class<?> targetClass) {
        ThriftServiceMethodCache methodCache = new ThriftServiceMethodCache(targetClass);
        methodCachedMap.put(targetClass.getName(), methodCache);
    }

    public static ThriftServiceMethodCache putIfAbsent(Class<?> targetClass) {
        ThriftServiceMethodCache updateMethodCache;
        String targetClassName = targetClass.getName();
        ThriftServiceMethodCache methodCache = methodCachedMap.get(targetClassName);
        if (methodCache == null && Objects.nonNull(updateMethodCache = methodCachedMap.putIfAbsent(targetClassName, methodCache = new ThriftServiceMethodCache(targetClass)))) {
            methodCache = updateMethodCache;
        }
        return methodCache;
    }
}

