/*
 * Decompiled with CFR 0.152.
 */
package cn.shellming.thrift.client.annotation;

import cn.shellming.thrift.client.annotation.EnableThriftClient;
import com.google.common.collect.Sets;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.commons.util.SpringFactoryImportSelector;
import org.springframework.core.env.Environment;

public class ThriftClientConfigurationSelector
extends SpringFactoryImportSelector<EnableThriftClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThriftClientConfigurationSelector.class);
    private static final Set<String> SERVICE_MODEL_SET = Sets.newHashSet((Object[])new String[]{"simple", "nonBlocking", "threadPool", "hsHa", "threadedSelector"});
    private static final String SERVICE_MODEL = "spring.thrift.client.service-model";

    protected boolean isEnabled() {
        Environment environment = this.getEnvironment();
        String serviceModel = (String)environment.getProperty(SERVICE_MODEL, String.class);
        boolean enableAutoConfiguration = SERVICE_MODEL_SET.contains(serviceModel);
        if (enableAutoConfiguration) {
            LOGGER.info("Enable thrift client auto configuration, service model {}", (Object)serviceModel);
        }
        return enableAutoConfiguration;
    }
}

