/*
 * Decompiled with CFR 0.152.
 */
package cn.shellming.thrift.client.wrapper;

import cn.shellming.thrift.client.wrapper.ThriftClientWrapper;
import java.util.Arrays;
import java.util.Objects;

public final class ThriftClientWrapperFactory {
    private ThriftClientWrapperFactory() {
    }

    public static ThriftClientWrapper wrapper(String thriftServiceId, String thriftServiceName, Object thriftClient, double version) {
        ThriftClientWrapper thriftServiceWrapper = version <= 0.0 ? new ThriftClientWrapper(thriftServiceName, thriftClient.getClass(), thriftClient) : new ThriftClientWrapper(thriftServiceName, thriftClient.getClass(), thriftClient, version);
        Class<?> clientClass = thriftClient.getClass().getSuperclass();
        if (Objects.isNull(clientClass)) {
            throw new IllegalStateException("No thrift Client found on service");
        }
        thriftServiceWrapper.setClientType(clientClass);
        Class ifaceClass = Arrays.stream(clientClass.getDeclaringClass().getDeclaredClasses()).filter(clazz -> clazz.getName().endsWith("$Iface")).findFirst().orElseThrow(() -> new IllegalStateException("No thrift Iface found on service"));
        thriftServiceWrapper.setType(thriftClient.getClass());
        String signature = String.join((CharSequence)"$", thriftServiceId, ifaceClass.getCanonicalName(), String.valueOf(version));
        thriftServiceWrapper.setThriftServiceSignature(signature);
        return thriftServiceWrapper;
    }
}

