/*
 * Decompiled with CFR 0.152.
 */
package cn.shellming.thrift.client.scanner;

import cn.shellming.thrift.client.common.ThriftServiceSignature;
import cn.shellming.thrift.client.scanner.ThriftClientAdvice;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import org.aopalliance.aop.Advice;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.protocol.TProtocol;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.beans.BeanUtils;

public class ThriftClientInvocationHandler
implements InvocationHandler {
    private ThriftServiceSignature serviceSignature;
    private Class<?> clientClass;
    private Constructor<? extends TServiceClient> clientConstructor;
    private ProxyFactoryBean proxyFactoryBean;

    public ThriftClientInvocationHandler(ThriftServiceSignature serviceSignature, Class<?> clientClass, Constructor<? extends TServiceClient> clientConstructor) throws Exception {
        this.serviceSignature = serviceSignature;
        this.clientClass = clientClass;
        this.clientConstructor = clientConstructor;
        this.proxyFactoryBean = this.initializeProxyFactoryBean();
    }

    private ProxyFactoryBean initializeProxyFactoryBean() throws Exception {
        Constructor<TServiceClient> constructor = this.clientConstructor;
        if (Objects.isNull(constructor)) {
            constructor = this.clientClass.getConstructor(TProtocol.class);
        }
        Object target = BeanUtils.instantiateClass(constructor, (Object[])new Object[]{null});
        ProxyFactoryBean factoryBean = new ProxyFactoryBean();
        factoryBean.setTarget(target);
        factoryBean.setBeanClassLoader(this.getClass().getClassLoader());
        ThriftClientAdvice clientAdvice = new ThriftClientAdvice(this.serviceSignature, this.clientConstructor);
        factoryBean.addAdvice((Advice)clientAdvice);
        factoryBean.setProxyTargetClass(true);
        factoryBean.setSingleton(true);
        factoryBean.setOptimize(true);
        factoryBean.setFrozen(true);
        return factoryBean;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.proxyFactoryBean.getObject();
    }
}

