/*
 * Decompiled with CFR 0.152.
 */
package cn.shellming.thrift.client.scanner;

import cn.shellming.thrift.client.cache.ThriftServiceMethodCacheManager;
import cn.shellming.thrift.client.common.ThriftClientContext;
import cn.shellming.thrift.client.common.ThriftServiceSignature;
import cn.shellming.thrift.client.discovery.ThriftConsulServerNode;
import cn.shellming.thrift.client.discovery.ThriftConsulServerNodeList;
import cn.shellming.thrift.client.exception.ThriftApplicationException;
import cn.shellming.thrift.client.exception.ThriftClientException;
import cn.shellming.thrift.client.exception.ThriftClientOpenException;
import cn.shellming.thrift.client.exception.ThriftClientRegistryException;
import cn.shellming.thrift.client.exception.ThriftClientRequestTimeoutException;
import cn.shellming.thrift.client.loadbalancer.RoundRobinRule;
import cn.shellming.thrift.client.loadbalancer.ThriftConsulServerListLoadBalancer;
import cn.shellming.thrift.client.pool.TransportKeyedObjectPool;
import cn.shellming.thrift.client.properties.ThriftClientPoolProperties;
import cn.shellming.thrift.client.properties.ThriftClientProperties;
import com.orbitz.consul.Consul;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Objects;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ThriftClientAdvice
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThriftClientAdvice.class);
    private static final String DISCOVERY_ADDRESS = "http://%s";
    private ThriftServiceSignature serviceSignature;
    private Constructor<? extends TServiceClient> clientConstructor;
    private ThriftConsulServerListLoadBalancer loadBalancer;
    private ThriftClientProperties properties;
    private TransportKeyedObjectPool objectPool;

    public ThriftClientAdvice(ThriftServiceSignature serviceSignature, Constructor<? extends TServiceClient> clientConstructor) {
        Consul consul;
        this.serviceSignature = serviceSignature;
        this.clientConstructor = clientConstructor;
        String consulAddress = ThriftClientContext.context().getRegistryAddress();
        try {
            consul = Consul.builder().withUrl(String.format(DISCOVERY_ADDRESS, consulAddress)).build();
        }
        catch (Exception e) {
            throw new ThriftClientRegistryException("Unable to access consul server, address is: " + consulAddress, e);
        }
        if (Objects.isNull(consul)) {
            throw new ThriftClientRegistryException("Unable to access consul server, address is: " + consulAddress);
        }
        ThriftConsulServerNodeList serverNodeList = ThriftConsulServerNodeList.singleton(consul);
        RoundRobinRule routerRule = new RoundRobinRule();
        this.loadBalancer = new ThriftConsulServerListLoadBalancer(serverNodeList, routerRule);
        routerRule.setLoadBalancer(this.loadBalancer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (Objects.isNull(this.properties)) {
            this.properties = ThriftClientContext.context().getProperties();
        }
        if (Objects.isNull((Object)this.objectPool)) {
            this.objectPool = ThriftClientContext.context().getObjectPool();
        }
        ThriftClientPoolProperties poolProperties = this.properties.getPool();
        String serviceId = this.serviceSignature.getThriftServiceId();
        ThriftConsulServerNode serverNode = this.loadBalancer.chooseServerNode(serviceId);
        String signature = this.serviceSignature.marker();
        Method invocationMethod = invocation.getMethod();
        Object[] args = invocation.getArguments();
        int retryTimes = 0;
        TTransport transport = null;
        while (true) {
            if (retryTimes++ > poolProperties.getRetryTimes()) {
                LOGGER.error("All thrift client call failed, method is {}, args is {}, retryTimes: {}", new Object[]{invocation.getMethod().getName(), args, retryTimes});
                throw new ThriftClientException("Thrift client call failed, thrift client signature is: " + this.serviceSignature.marker());
            }
            try {
                transport = this.objectPool.borrowObject(serverNode);
                TCompactProtocol protocol = new TCompactProtocol(transport);
                TMultiplexedProtocol multiplexedProtocol = new TMultiplexedProtocol((TProtocol)protocol, signature);
                TServiceClient client = this.clientConstructor.newInstance(multiplexedProtocol);
                Method cachedMethod = ThriftServiceMethodCacheManager.getMethod(client.getClass(), invocationMethod.getName(), invocationMethod.getParameterTypes());
                Object object = ReflectionUtils.invokeMethod((Method)cachedMethod, (Object)client, (Object[])args);
                return object;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException e) {
                throw new ThriftClientOpenException("Unable to open thrift client", e);
            }
            catch (UndeclaredThrowableException e) {
                Throwable undeclaredThrowable = e.getUndeclaredThrowable();
                if (undeclaredThrowable instanceof TTransportException) {
                    TTransportException innerException = (TTransportException)e.getUndeclaredThrowable();
                    Throwable realException = innerException.getCause();
                    if (realException instanceof SocketTimeoutException) {
                        if (transport != null) {
                            transport.close();
                        }
                        LOGGER.error("Thrift client request timeout, ip is {}, port is {}, timeout is {}, method is {}, args is {}", new Object[]{serverNode.getHost(), serverNode.getPort(), serverNode.getTimeout(), invocation.getMethod(), args});
                        throw new ThriftClientRequestTimeoutException("Thrift client request timeout", e);
                    }
                    if (realException == null && innerException.getType() == 4) {
                        this.objectPool.clear(serverNode);
                        if (transport == null) continue;
                        transport.close();
                        continue;
                    }
                    if (!(realException instanceof SocketException)) continue;
                    this.objectPool.clear(serverNode);
                    if (transport == null) continue;
                    transport.close();
                    continue;
                }
                if (undeclaredThrowable instanceof TApplicationException) {
                    LOGGER.error("Thrift end of file, ip is {}, port is {}, timeout is {}, method is {}, args is {}, retryTimes is {}", new Object[]{serverNode.getHost(), serverNode.getPort(), serverNode.getTimeout(), invocation.getMethod(), args, retryTimes});
                    if (retryTimes >= poolProperties.getRetryTimes()) {
                        throw new ThriftApplicationException("Thrift end of file", e);
                    }
                    this.objectPool.clear(serverNode);
                    if (transport == null) continue;
                    transport.close();
                    continue;
                }
                if (undeclaredThrowable instanceof TException) {
                    throw undeclaredThrowable;
                }
                throw e;
            }
            catch (Exception e) {
                if (e instanceof ThriftClientOpenException) {
                    Throwable realCause = e.getCause().getCause();
                    if (!(realCause instanceof SocketException) || !realCause.getMessage().contains("Network is unreachable")) continue;
                    throw e;
                }
                throw e;
            }
            finally {
                try {
                    if (this.objectPool == null || transport == null) continue;
                    this.objectPool.returnObject(serverNode, transport);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
                continue;
            }
            break;
        }
    }
}

