/*
 * Decompiled with CFR 0.152.
 */
package cn.shellming.thrift.client.pool;

import cn.shellming.thrift.client.common.ThriftServerNode;
import cn.shellming.thrift.client.exception.ThriftClientConfigException;
import cn.shellming.thrift.client.exception.ThriftClientOpenException;
import cn.shellming.thrift.client.pool.ThriftTransportFactory;
import cn.shellming.thrift.client.properties.ThriftClientPoolProperties;
import cn.shellming.thrift.client.properties.ThriftClientProperties;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportKeyedPooledObjectFactory
extends BaseKeyedPooledObjectFactory<ThriftServerNode, TTransport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportKeyedPooledObjectFactory.class);
    private ThriftClientProperties properties;

    public TransportKeyedPooledObjectFactory(ThriftClientProperties properties) {
        this.properties = properties;
    }

    public TTransport create(ThriftServerNode key) throws Exception {
        int connectTimeout;
        if (StringUtils.isBlank((CharSequence)key.getHost())) {
            throw new ThriftClientConfigException("Invalid Thrift server, node IP address: " + key.getHost());
        }
        if (key.getPort() <= 0 || key.getPort() > 65535) {
            throw new ThriftClientConfigException("Invalid Thrift server, node port: " + key.getPort());
        }
        ThriftClientPoolProperties poolProperties = this.properties.getPool();
        TTransport transport = Objects.isNull(poolProperties) ? ThriftTransportFactory.determineTTranport(this.properties.getServiceModel(), key) : ((connectTimeout = poolProperties.getConnectTimeout()) > 0 ? ThriftTransportFactory.determineTTranport(this.properties.getServiceModel(), key, connectTimeout) : ThriftTransportFactory.determineTTranport(this.properties.getServiceModel(), key));
        try {
            transport.open();
            LOGGER.info("Open a new transport {}", (Object)transport);
        }
        catch (TTransportException e) {
            throw new ThriftClientOpenException("Connect to " + key.getHost() + ":" + key.getPort() + " failed", e);
        }
        return transport;
    }

    public PooledObject<TTransport> wrap(TTransport value) {
        return new DefaultPooledObject((Object)value);
    }

    public boolean validateObject(ThriftServerNode key, PooledObject<TTransport> value) {
        if (Objects.isNull(value)) {
            LOGGER.warn("PooledObject is already null");
            return false;
        }
        TTransport transport = (TTransport)value.getObject();
        if (Objects.isNull(transport)) {
            LOGGER.warn("Pooled transport is already null");
            return false;
        }
        try {
            return transport.isOpen();
        }
        catch (Exception e) {
            LOGGER.error(e.getCause().getMessage());
            return false;
        }
    }

    public void destroyObject(ThriftServerNode key, PooledObject<TTransport> value) throws Exception {
        if (Objects.nonNull(value)) {
            TTransport transport = (TTransport)value.getObject();
            if (Objects.nonNull(transport)) {
                transport.close();
            }
            value.markAbandoned();
        }
    }
}

