/*
 * Decompiled with CFR 0.152.
 */
package cn.shellming.thrift.client.loadbalancer;

import cn.shellming.thrift.client.common.ThriftServerNode;
import cn.shellming.thrift.client.loadbalancer.AbstractLoadBalancerRule;
import cn.shellming.thrift.client.loadbalancer.ILoadBalancer;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinRule
extends AbstractLoadBalancerRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoundRobinRule.class);
    private AtomicInteger nextServerCyclicCounter = new AtomicInteger();

    public RoundRobinRule() {
    }

    public RoundRobinRule(ILoadBalancer lb) {
        this();
        this.setLoadBalancer(lb);
    }

    @Override
    public ThriftServerNode choose(String key) {
        return this.choose(this.getLoadBalancer(), key);
    }

    private ThriftServerNode choose(ILoadBalancer lb, String key) {
        if (lb == null) {
            LOGGER.warn("No specified load balancer");
            return null;
        }
        ThriftServerNode serverNode = null;
        int count = 0;
        while (serverNode == null && count++ < 10) {
            int nextServerIndex;
            ArrayList serverNodes = lb.getServerNodes(key);
            if (CollectionUtils.isEmpty(serverNodes)) {
                Map serverNodesMap = lb.getAllServerNodes();
                if (MapUtils.isEmpty(serverNodesMap) || !serverNodesMap.containsKey(key)) {
                    LOGGER.warn("No up servers of key {}, available from load balancer: " + lb, (Object)key);
                    return null;
                }
                LinkedHashSet thriftServerNodes = serverNodesMap.get(key);
                if (CollectionUtils.isEmpty(thriftServerNodes)) {
                    LOGGER.warn("No up servers of key {}, available from load balancer: " + lb, (Object)key);
                    return null;
                }
                serverNodes = Lists.newArrayList(thriftServerNodes);
            }
            if ((serverNode = (ThriftServerNode)serverNodes.get(nextServerIndex = this.incrementAndGetModulo(serverNodes.size()))) != null) continue;
            Thread.yield();
        }
        if (count >= 10) {
            LOGGER.warn("No available alive server nodes after 10 tries from load balancer: " + lb);
        }
        return serverNode;
    }

    private int incrementAndGetModulo(int modulo) {
        int next;
        int current;
        while (!this.nextServerCyclicCounter.compareAndSet(current = this.nextServerCyclicCounter.get(), next = (current + 1) % modulo)) {
        }
        return next;
    }
}

