/*
 * Decompiled with CFR 0.152.
 */
package cn.shellming.thrift.client.discovery;

import cn.shellming.thrift.client.discovery.ServerListUpdater;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftConsulServerListUpdater
implements ServerListUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThriftConsulServerListUpdater.class);
    private final AtomicBoolean isActive = new AtomicBoolean(false);
    private final long initialDelayMs;
    private final long refreshIntervalMs;
    private volatile ScheduledFuture<?> scheduledFuture;

    public ThriftConsulServerListUpdater() {
        this(30000L);
    }

    public ThriftConsulServerListUpdater(long refreshIntervalMs) {
        this(0L, refreshIntervalMs);
    }

    public ThriftConsulServerListUpdater(long initialDelayMs, long refreshIntervalMs) {
        this.initialDelayMs = initialDelayMs;
        this.refreshIntervalMs = refreshIntervalMs;
    }

    private static ScheduledThreadPoolExecutor getRefreshExecutor() {
        return LazyHolder.serverListRefreshExecutor;
    }

    @Override
    public synchronized void start(ServerListUpdater.UpdateAction updateAction) {
        if (this.isActive.compareAndSet(false, true)) {
            Runnable scheduledRunnable = () -> {
                if (!this.isActive.get()) {
                    if (this.scheduledFuture != null) {
                        this.scheduledFuture.cancel(true);
                    }
                    return;
                }
                try {
                    updateAction.doUpdate();
                }
                catch (Exception e) {
                    LOGGER.warn("Failed one do update action", (Throwable)e);
                }
            };
            this.scheduledFuture = ThriftConsulServerListUpdater.getRefreshExecutor().scheduleWithFixedDelay(scheduledRunnable, this.initialDelayMs, this.refreshIntervalMs, TimeUnit.MILLISECONDS);
        } else {
            LOGGER.info("Already active, no other operation");
        }
    }

    @Override
    public void stop() {
        if (this.isActive.compareAndSet(true, false)) {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(true);
            }
        } else {
            LOGGER.info("Not active, no other operation");
        }
    }

    private static class LazyHolder {
        private static final int CORE_THREAD = 2;
        private static Thread shutdownThread;
        static ScheduledThreadPoolExecutor serverListRefreshExecutor;

        private LazyHolder() {
        }

        private static void shutdownExecutorPool() {
            if (serverListRefreshExecutor != null) {
                serverListRefreshExecutor.shutdown();
                if (shutdownThread != null) {
                    try {
                        Runtime.getRuntime().removeShutdownHook(shutdownThread);
                    }
                    catch (IllegalStateException e) {
                        LOGGER.error("Failed to shutdown the Executor Pool for ThriftConsulServerListUpdater", (Throwable)e);
                    }
                }
            }
        }

        static {
            ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat("ThriftConsulServerListUpdater-%d").setDaemon(true).build();
            serverListRefreshExecutor = new ScheduledThreadPoolExecutor(2, factory);
            shutdownThread = new Thread(() -> {
                LOGGER.info("Shutting down the Executor Pool for ThriftConsulServerListUpdater");
                LazyHolder.shutdownExecutorPool();
            });
            Runtime.getRuntime().addShutdownHook(shutdownThread);
        }
    }
}

