/*
 * Decompiled with CFR 0.152.
 */
package cn.shellming.thrift.client.cache;

import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;

public class ThriftServiceMethodCache {
    private Map<String, Method> methodCachedMap = Maps.newHashMap();
    private final Class<?> cacheClass;

    public ThriftServiceMethodCache(Class<?> cacheClass) {
        this.cacheClass = cacheClass;
        Method[] declaredMethods = cacheClass.getDeclaredMethods();
        ArrayList<String> nonCachedMethods = new ArrayList<String>();
        for (Method method : declaredMethods) {
            if (method.isAccessible() || (1 & method.getModifiers()) <= 0 || (8 & method.getModifiers()) != 0) continue;
            this.put(method);
            nonCachedMethods.add(method.getName());
        }
        for (String methodName : nonCachedMethods) {
            this.methodCachedMap.remove(methodName);
        }
    }

    private void put(Method method) {
        Class<?>[] types = method.getParameterTypes();
        StringBuilder cachedKey = new StringBuilder(method.getName() + types.length);
        for (Class<?> type : types) {
            String typeName = ((Object)type).toString();
            if (typeName.startsWith("class ")) {
                typeName = typeName.substring(6);
            }
            cachedKey.append(typeName);
        }
        this.methodCachedMap.put(cachedKey.toString(), method);
    }

    public Method getMethod(String name, Class<?> ... arguments) throws NoSuchMethodException {
        Method method = this.methodCachedMap.get(name);
        if (method == null) {
            StringBuilder nameBuilder = new StringBuilder(name + arguments.length);
            for (Class<?> argument : arguments) {
                nameBuilder.append(argument.getName());
            }
            name = nameBuilder.toString();
            method = this.methodCachedMap.get(name);
        }
        return method;
    }

    public Class<?> getCacheClass() {
        return this.cacheClass;
    }
}

