/*
 * Decompiled with CFR 0.152.
 */
package cn.shellming.thrift.client;

import cn.shellming.thrift.client.annotation.ThriftRefer;
import cn.shellming.thrift.client.common.ThriftClientAware;
import cn.shellming.thrift.client.exception.ThriftClientInstantiateException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class ThriftClientBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThriftClientBeanPostProcessor.class);
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        TargetSource targetSource;
        Object target = bean;
        if (AopUtils.isJdkDynamicProxy((Object)target)) {
            targetSource = ((Advised)target).getTargetSource();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Target object {} uses jdk dynamic proxy");
            }
            try {
                target = targetSource.getTarget();
            }
            catch (Exception e) {
                throw new ThriftClientInstantiateException("Failed to get target bean from " + target, e);
            }
        }
        if (AopUtils.isCglibProxy((Object)target)) {
            targetSource = ((Advised)target).getTargetSource();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Target object {} uses cglib proxy");
            }
            try {
                target = targetSource.getTarget();
            }
            catch (Exception e) {
                throw new ThriftClientInstantiateException("Failed to get target bean from " + target, e);
            }
        }
        Class<?> targetClass = target.getClass();
        Object targetBean = target;
        ReflectionUtils.doWithFields(targetClass, field -> {
            Object injectedBean;
            ThriftRefer thriftRefer = (ThriftRefer)AnnotationUtils.findAnnotation((AnnotatedElement)field, ThriftRefer.class);
            String referName = StringUtils.isNotBlank((CharSequence)thriftRefer.value()) ? thriftRefer.value() : thriftRefer.name();
            Class<?> fieldType = field.getType();
            if (StringUtils.isNotBlank((CharSequence)referName)) {
                injectedBean = this.applicationContext.getBean(fieldType, new Object[]{referName});
                injectedBean = Optional.ofNullable(injectedBean).orElseThrow(() -> new ThriftClientInstantiateException("Detected non-qualified bean with name {}" + referName));
                ReflectionUtils.makeAccessible((Field)field);
                ReflectionUtils.setField((Field)field, (Object)targetBean, (Object)injectedBean);
            } else {
                Map injectedBeanMap = this.applicationContext.getBeansOfType(field.getType());
                if (MapUtils.isEmpty((Map)injectedBeanMap)) {
                    throw new ThriftClientInstantiateException("Detected non-qualified bean of {}" + fieldType.getSimpleName());
                }
                if (injectedBeanMap.size() > 1) {
                    throw new ThriftClientInstantiateException("Detected ambiguous beans of {}" + fieldType.getSimpleName());
                }
                injectedBean = injectedBeanMap.entrySet().stream().findFirst().map(Map.Entry::getValue).orElseThrow(() -> new ThriftClientInstantiateException("Detected non-qualified bean of {}" + fieldType.getSimpleName()));
                ReflectionUtils.makeAccessible((Field)field);
                ReflectionUtils.setField((Field)field, (Object)targetBean, (Object)injectedBean);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Bean {} is injected into target bean {}, field {}", new Object[]{injectedBean, targetBean, field.getName()});
            }
        }, field -> AnnotationUtils.getAnnotation((AnnotatedElement)field, ThriftRefer.class) != null);
        ReflectionUtils.MethodFilter methodFilter = method -> {
            boolean basicCondition;
            boolean bl = basicCondition = AnnotationUtils.getAnnotation((Method)method, ThriftRefer.class) != null && method.getParameterCount() > 0 && method.getReturnType() == Void.TYPE;
            if (!basicCondition) {
                return false;
            }
            return Arrays.stream(method.getParameters()).map(Parameter::getType).map(ThriftClientAware.class::isAssignableFrom).reduce((param1, param2) -> param1 != false && param2 != false).get();
        };
        ReflectionUtils.doWithMethods(targetClass, method -> {
            Parameter[] parameters = method.getParameters();
            Object[] objectArray = Arrays.stream(parameters).map(parameter -> {
                Class<?> parameterType = parameter.getType();
                Map injectedBeanMap = this.applicationContext.getBeansOfType(parameterType);
                if (MapUtils.isEmpty((Map)injectedBeanMap)) {
                    throw new ThriftClientInstantiateException("Detected non-qualified bean of {}" + parameterType.getSimpleName());
                }
                if (injectedBeanMap.size() > 1) {
                    throw new ThriftClientInstantiateException("Detected ambiguous beans of {}" + parameterType.getSimpleName());
                }
                return injectedBeanMap.entrySet().stream().findFirst().map(Map.Entry::getValue).orElseThrow(() -> new ThriftClientInstantiateException("Detected non-qualified bean of {}" + parameterType.getSimpleName()));
            }).toArray();
            ReflectionUtils.makeAccessible((Method)method);
            ReflectionUtils.invokeMethod((Method)method, (Object)targetBean, (Object[])new Object[]{objectArray});
        }, (ReflectionUtils.MethodFilter)methodFilter);
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

