SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;
-- ----------------------------
-- Table structure for event_consumer_group
-- ----------------------------
DROP TABLE IF EXISTS `event_consumer_group`;
CREATE TABLE `event_consumer_group`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '序号',
  `version` int(11) NOT NULL COMMENT '版本号',
  `state` int(11) NOT NULL COMMENT '处理状态',
  `uuid_` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_german2_ci DEFAULT NULL COMMENT 'uuid',
  `off_set_` bigint(11) DEFAULT NULL COMMENT '组偏移量',
  `consumer_group_` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_german2_ci DEFAULT NULL COMMENT '特定消费组',
  `last_deal_time` datetime(0) DEFAULT NULL COMMENT '最新执行时间',
  `next_send_time` datetime(0) DEFAULT NULL COMMENT '下次发送时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 0 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_german2_ci ROW_FORMAT = Dynamic;
-- ----------------------------
-- Table structure for event_entry
-- ----------------------------
DROP TABLE IF EXISTS `event_entry`;
CREATE TABLE `event_entry`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '序号',
  `created_by` bigint(20) DEFAULT NULL COMMENT '创建者',
  `created_time` datetime(0) NOT NULL COMMENT '创建时间',
  `last_modified_by` bigint(20) DEFAULT NULL COMMENT '修改者',
  `last_modified_time` datetime(0) DEFAULT NULL COMMENT '修改时间',
  `version` int(11) NOT NULL COMMENT '版本号',
  `uuid_` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_german2_ci DEFAULT NULL COMMENT 'uuid',
  `parent_id` int(11) UNSIGNED ZEROFILL NOT NULL COMMENT '父节点数据',
  `event_message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_german2_ci COMMENT '消息体内容',
  `event_type` int(11) NOT NULL COMMENT '消息类型',
  `ack_type` int(11) NOT NULL COMMENT '确认方式',
  `topic` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_german2_ci NOT NULL COMMENT '主题',
  `send_times` int(11) DEFAULT NULL COMMENT '发送次数',
  `retries` int(11) DEFAULT NULL COMMENT '最大重试次数',
  `state` int(11) NOT NULL COMMENT '发送状态',
  `consumer_group_` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_german2_ci DEFAULT NULL COMMENT '特定消费组',
  `next_send_time` datetime(0) DEFAULT NULL COMMENT '下次发送时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 0 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_german2_ci ROW_FORMAT = Dynamic;

SET FOREIGN_KEY_CHECKS = 1;
