/*
 * Decompiled with CFR 0.152.
 */
package cn.shazhengbo.kafka.storage.task;

import cn.shazhengbo.kafka.annotation.KafkaMessageState;
import cn.shazhengbo.kafka.config.SysConfig;
import cn.shazhengbo.kafka.store.AbstractMessageStore;
import cn.shazhengbo.kafka.store.AbstractQueryMessageStore;
import cn.shazhengbo.kafka.store.RetryMessage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class TaskSendMessage {
    private static final Logger log = LoggerFactory.getLogger(TaskSendMessage.class);
    @Autowired(required=false)
    @Qualifier(value="queryMessageStore")
    private AbstractQueryMessageStore queryMessageStore;
    @Autowired(required=false)
    private AbstractMessageStore messageStore;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private SysConfig sysConfig;

    @Scheduled(fixedDelay=200L)
    public void execution() {
        try {
            List list;
            if (this.sysConfig.isStoreMessage() && this.sysConfig.isMaster() && (list = this.queryMessageStore.topsRetryMessage(100)) != null && !list.isEmpty()) {
                for (RetryMessage retryMessage : list) {
                    try {
                        this.kafkaTemplate.send(retryMessage.getTopic(), (Object)retryMessage.getEventMessage());
                        this.messageStore.sendState(retryMessage.getTopic(), retryMessage.getUuid_(), KafkaMessageState.SUCCESS);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                        this.messageStore.sendState(retryMessage.getTopic(), retryMessage.getUuid_(), KafkaMessageState.FAIL);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
    }
}

