/*
 * Decompiled with CFR 0.152.
 */
package cn.shazhengbo.kafka.storage.service;

import cn.shazhengbo.kafka.annotation.KafkaAckType;
import cn.shazhengbo.kafka.annotation.KafkaMessageState;
import cn.shazhengbo.kafka.annotation.KafkaMessageType;
import cn.shazhengbo.kafka.storage.entity.MessageConsumerGroup;
import cn.shazhengbo.kafka.storage.entity.MessageEventEntery;
import cn.shazhengbo.kafka.storage.mapper.IMessageConsumerGroupMapper;
import cn.shazhengbo.kafka.storage.mapper.IMessageEventEnteryMapper;
import cn.shazhengbo.kafka.store.AbstractMessageStore;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventMessageStore
extends AbstractMessageStore {
    @Autowired
    private IMessageEventEnteryMapper iMessageEventEnteryMapper;
    @Autowired
    private IMessageConsumerGroupMapper consumerGroupMapper;

    public void store(String topic, int retries, KafkaMessageType type, KafkaAckType ackType, String message) {
        MessageEventEntery entery = new MessageEventEntery();
        entery.created(topic, retries, type, ackType, message);
        this.iMessageEventEnteryMapper.insert(entery);
    }

    public void sendState(String topic, String uuid, KafkaMessageState state) {
        MessageEventEntery entery = (MessageEventEntery)this.iMessageEventEnteryMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"topic", (Object)topic)).eq((Object)"uuid_", (Object)uuid)).last(" limit 0,1"));
        if (entery != null) {
            entery.modified(state);
            this.iMessageEventEnteryMapper.updateById(entery);
        }
    }

    public void retryMessage(long offSet, String uuid, String topic, String consumerGroup, long maxAckCount) {
        MessageEventEntery entery = (MessageEventEntery)this.iMessageEventEnteryMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"uuid_", (Object)uuid)).eq((Object)"topic", (Object)topic)).last(" limit 0,1"));
        if (entery != null) {
            long unSendCount = this.countUnSend(consumerGroup, uuid, topic, entery.getParentId());
            System.out.println(unSendCount);
            if (entery != null && unSendCount <= 0L) {
                MessageConsumerGroup group;
                long count = this.iMessageEventEnteryMapper.selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"parent_id", (Object)entery.getId())).eq((Object)"consumer_group_", (Object)consumerGroup));
                if (count <= maxAckCount) {
                    entery.retry(consumerGroup, count);
                    this.iMessageEventEnteryMapper.insert(entery);
                }
                if ((group = (MessageConsumerGroup)this.consumerGroupMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"uuid_", (Object)uuid)).eq((Object)"consumer_group_", (Object)consumerGroup)).last("limit 0,1"))) == null) {
                    group = new MessageConsumerGroup();
                    group.fail(offSet, uuid, consumerGroup, entery.getNextSendTime());
                    this.consumerGroupMapper.insert(group);
                } else {
                    group.setOffSet_(offSet);
                    group.setNextSendTime(entery.getNextSendTime());
                    this.consumerGroupMapper.updateById(group);
                }
            }
        }
    }

    private int countUnSend(String consumerGroup, String uuid, String topic, long parentId) {
        return this.iMessageEventEnteryMapper.countUnsend(consumerGroup, uuid, topic, parentId);
    }

    public void ackDeal(String topic, long offSet, String uuid, String consumerGroup, KafkaAckType ackType) {
        if (KafkaAckType.AUTO.equals((Object)ackType)) {
            MessageConsumerGroup group = (MessageConsumerGroup)this.consumerGroupMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"uuid_", (Object)uuid)).eq((Object)"consumer_group_", (Object)consumerGroup)).last("limit 0,1"));
            if (group == null) {
                group = new MessageConsumerGroup();
                group.ack(offSet, uuid, consumerGroup);
                this.consumerGroupMapper.insert(group);
            } else {
                group.setOffSet_(offSet);
                group.setNextSendTime(LocalDateTime.now());
                this.consumerGroupMapper.updateById(group);
            }
        } else if (KafkaAckType.RPC.equals((Object)ackType)) {
            // empty if block
        }
        this.consumerGroupMapper.delete((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"uuid_", (Object)uuid)).eq((Object)"consumer_group_", (Object)consumerGroup)).eq((Object)"state", (Object)0));
    }
}

