package cn.shazhengbo.kafka.storage.task;

import cn.shazhengbo.kafka.annotation.KafkaMessageState;
import cn.shazhengbo.kafka.config.SysConfig;
import cn.shazhengbo.kafka.store.AbstractMessageStore;
import cn.shazhengbo.kafka.store.AbstractQueryMessageStore;
import cn.shazhengbo.kafka.store.RetryMessage;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author CrazyShaQiuShi
 * @version 1.0
 * @description: 发送消息任务
 * @date 2020/8/23 6:29
 */
@Slf4j
@Component
public class TaskSendMessage {
    @Autowired(required = false)
    @Qualifier(value = "queryMessageStore")
    private AbstractQueryMessageStore queryMessageStore;
    @Autowired(required = false)
    private AbstractMessageStore messageStore;
    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private SysConfig sysConfig;

    @Scheduled(fixedDelay = 200)
    public void execution() {
        try {
            if (sysConfig.isStoreMessage() && sysConfig.isMaster()) {
                List<RetryMessage> list = queryMessageStore.topsRetryMessage(100);
                if (list != null && !list.isEmpty()) {
                    for (RetryMessage retryMessage : list) {
                        try {
                            kafkaTemplate.send(retryMessage.getTopic(), retryMessage.getEventMessage());
                            messageStore.sendState(retryMessage.getTopic(), retryMessage.getUuid_(), KafkaMessageState.SUCCESS);
                        } catch (Exception e) {
                            log.error(e.getMessage());
                            messageStore.sendState(retryMessage.getTopic(), retryMessage.getUuid_(), KafkaMessageState.FAIL);
                        }
                    }
                }
            }
        } catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
    }
}
