package cn.shazhengbo.kafka.storage.service;

import cn.shazhengbo.kafka.store.AbstractQueryMessageStore;
import cn.shazhengbo.kafka.store.RetryMessage;
import cn.shazhengbo.kafka.storage.mapper.IMessageEventEnteryMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * @author CrazyShaQiuShi
 * @version 1.0
 * @description 消息查询服务类
 * @date 2020/8/22 15:48
 */
@Component("queryMessageStore")
public class QueryMessageStore extends AbstractQueryMessageStore {
    @Autowired
    private IMessageEventEnteryMapper iMessageEventEnteryMapper;

    @Override
    public List<RetryMessage> topsRetryMessage(int num) {
        List<RetryMessage> list = iMessageEventEnteryMapper.topsRetry(num, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        return list;
    }

}
