package cn.shazhengbo.kafka.storage.mapper;

import cn.shazhengbo.kafka.store.RetryMessage;
import cn.shazhengbo.kafka.storage.entity.MessageEventEntery;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;
import java.util.List;

/**
 * @author CrazyShaQiuShi
 * @version 1.0
 * @description: 消息dao操作层
 * @date 2020/8/22 21:22
 */
@Repository
@Mapper
public interface IMessageEventEnteryMapper extends BaseMapper<MessageEventEntery> {
    /**
     * 获取前几条需要发送的数据
     *
     * @param num
     * @return
     */
    List<RetryMessage> topsRetry(@Param("num") int num, @Param("nowDateTime") String nowDateTime);

    /**
     * 统计未发送的数据量
     * @param consumerGroup
     * @param uuid
     * @param topic
     * @return
     */
    int countUnsend(@Param("consumerGroup") String consumerGroup, @Param("uuid") String uuid, @Param("topic") String topic,@Param("parentId")long parentId);
}
