/*
 * Decompiled with CFR 0.152.
 */
package cn.shazhengbo.kafka.utils.json;

import cn.shazhengbo.kafka.utils.TrimStringDeserializer;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonHelper {
    private static final Logger log = LoggerFactory.getLogger(JsonHelper.class);
    public static ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static Gson GSON;

    public static <T> T clone(T source) {
        Object cloned;
        if (source == null) {
            return null;
        }
        try {
            cloned = OBJECT_MAPPER.readerFor(source.getClass()).readValue(OBJECT_MAPPER.writeValueAsString(source));
        }
        catch (IOException ex) {
            throw new RuntimeException("json\u5e8f\u5217\u5316\u6216\u53cd\u5e8f\u5217\u5316\u5f02\u5e38", ex);
        }
        return (T)cloned;
    }

    public static String stringify(Object object) {
        String json;
        if (object == null) {
            return "";
        }
        try {
            json = OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (Exception ex) {
            throw new RuntimeException("json\u5e8f\u5217\u5316\u5f02\u5e38", ex);
        }
        return json;
    }

    public static String stringGson(Object object) {
        String json;
        if (object == null) {
            return "";
        }
        try {
            json = GSON.toJson(object);
        }
        catch (Exception ex) {
            throw new RuntimeException("json\u5e8f\u5217\u5316\u5f02\u5e38", ex);
        }
        return json;
    }

    public static <T> T resolve(String json, Class<T> clazz) {
        Object obj;
        try {
            obj = OBJECT_MAPPER.readerFor(clazz).readValue(json);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("json\u53cd\u5e8f\u5217\u5316\u5f02\u5e38", e);
        }
        return (T)obj;
    }

    public static <T> T resolveGson(String json, Class<T> clazz) {
        Object obj;
        try {
            obj = GSON.fromJson(json, clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("json\u53cd\u5e8f\u5217\u5316\u5f02\u5e38", e);
        }
        return (T)obj;
    }

    public static <T> T resolveGson(String json, Type type) {
        Object obj;
        try {
            obj = GSON.fromJson(json, type);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("json\u53cd\u5e8f\u5217\u5316\u5f02\u5e38", e);
        }
        return (T)obj;
    }

    public static <T> T resolve(InputStream stream, Class<T> clazz) {
        Object obj;
        try {
            obj = OBJECT_MAPPER.readerFor(clazz).readValue(stream);
        }
        catch (IOException ex) {
            throw new RuntimeException("\u89e3\u6790\u5931\u8d25", ex);
        }
        return (T)obj;
    }

    public static <T> List<T> resolve(String json, Class<T> itemClass, Function<Object, T> converter) {
        ArrayList result = new ArrayList();
        try {
            List list = (List)OBJECT_MAPPER.readerFor(List.class).readValue(json);
            list.forEach(l -> result.add(converter.apply(l)));
        }
        catch (IOException ex) {
            throw new RuntimeException("\u89e3\u6790\u5931\u8d25", ex);
        }
        return result;
    }

    public static <T> List<T> resolveListGson(String json, Class<T> itemClass) {
        List list;
        try {
            list = (List)GSON.fromJson(json, new TypeToken<List<T>>(){}.getType());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("\u89e3\u6790\u5931\u8d25", ex);
        }
        return list;
    }

    public static <S, T> T convert(S source, Class<T> clazz) {
        if (source == null) {
            return null;
        }
        return JsonHelper.resolve(JsonHelper.stringify(source), clazz);
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        OBJECT_MAPPER.registerModule((Module)new Jdk8Module());
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(String.class, (JsonDeserializer)new TrimStringDeserializer());
        OBJECT_MAPPER.registerModules(new Module[]{javaTimeModule, simpleModule});
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDateTime.class, (json, type, jsonDeserializationContext) -> {
            String datetime = json.getAsJsonPrimitive().getAsString();
            return LocalDateTime.parse(datetime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }).registerTypeAdapter(LocalDate.class, (json, type, jsonDeserializationContext) -> {
            String datetime = json.getAsJsonPrimitive().getAsString();
            return LocalDate.parse(datetime, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }).registerTypeAdapter(LocalDate.class, (localDate, type, jsonSerializationContext) -> {
            String ldtStr = "";
            if (localDate != null) {
                ldtStr = localDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            }
            return new JsonPrimitive(ldtStr);
        }).registerTypeAdapter(LocalDateTime.class, (localDateTime, type, jsonSerializationContext) -> {
            String ldtStr = "";
            if (localDateTime != null) {
                ldtStr = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            }
            return new JsonPrimitive(ldtStr);
        }).create();
        GSON = gsonBuilder.create();
    }
}

