/*
 * Decompiled with CFR 0.152.
 */
package cn.shazhengbo.kafka.message;

import cn.shazhengbo.kafka.annotation.BaseGlobalEntity;
import cn.shazhengbo.kafka.annotation.EventMessage;
import cn.shazhengbo.kafka.annotation.KafkaMessageType;
import cn.shazhengbo.kafka.config.SysConfig;
import cn.shazhengbo.kafka.store.AbstractMessageStore;
import cn.shazhengbo.kafka.utils.json.JsonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
public class EventMessageTemplate {
    private static final Logger log = LoggerFactory.getLogger(EventMessageTemplate.class);
    private final KafkaTemplate<String, String> kafkaTemplate;
    private final SysConfig sysConfig;
    @Autowired(required=false)
    private AbstractMessageStore eventMessageStore;

    @Autowired
    public EventMessageTemplate(KafkaTemplate kafkaTemplate, SysConfig sysConfig) {
        this.kafkaTemplate = kafkaTemplate;
        this.sysConfig = sysConfig;
    }

    public void sendMessage(Object object, Class<?> clazz) throws Exception {
        EventMessage message = clazz.getAnnotation(EventMessage.class);
        String completeTopic = String.format("%s.%s", this.sysConfig.getTopicPrefix(), message.topic());
        String messageText = JsonHelper.stringify(object);
        if (KafkaMessageType.RECPRD.equals((Object)message.type())) {
            this.sendMessageStorage(object, message, completeTopic, messageText);
        } else if (KafkaMessageType.NO_RECORD.equals((Object)message.type())) {
            this.sendMessageNoRecord(completeTopic, messageText);
        }
    }

    private void sendMessageNoRecord(String completeTopic, String messageText) {
        try {
            this.kafkaTemplate.send(completeTopic, (Object)messageText);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6d88\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    private void sendMessageStorage(Object object, EventMessage message, String completeTopic, String messageText) throws Exception {
        if (this.sysConfig.isStoreMessage()) {
            if (this.eventMessageStore == null) {
                throw new Exception("\u60a8\u672a\u914d\u7f6emessageStore!");
            }
            if (this.verifyStore(object, message)) {
                this.eventMessageStore.store(completeTopic, message.retries(), message.type(), message.ackType(), messageText);
            }
        } else {
            throw new Exception("\u9700\u8981\u5f00\u542f\u6d88\u606f\u5b58\u50a8\u6a21\u5f0f,\u5e76\u914d\u7f6emessageStore\u540e\u624d\u80fd\u4f7f\u7528\u6b21\u65b9\u6cd5");
        }
    }

    private boolean verifyStore(Object object, EventMessage message) throws Exception {
        Class<BaseGlobalEntity> globalClazz = BaseGlobalEntity.class;
        if (!globalClazz.isAssignableFrom(object.getClass())) {
            throw new Exception("\u5f00\u542f\u5b58\u50a8,\u6d88\u606f\u4f53\u5fc5\u987b\u7ee7\u627fBaseGlobalEntity\u7c7b");
        }
        if (message.type().equals((Object)KafkaMessageType.RECPRD)) {
            return true;
        }
        throw new Exception("\u5b58\u50a8\u53d1\u9001,@EventMessage\u9700\u8981\u6307\u5b9atype!");
    }
}

