/*
 * Decompiled with CFR 0.152.
 */
package cn.shazhengbo.kafka.event.listener;

import cn.shazhengbo.kafka.annotation.EventMessage;
import cn.shazhengbo.kafka.annotation.KafkaAckType;
import cn.shazhengbo.kafka.config.SysConfig;
import cn.shazhengbo.kafka.message.KafkaEventMessageHandler;
import cn.shazhengbo.kafka.store.AbstractMessageStore;
import cn.shazhengbo.kafka.utils.json.JsonHelper;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class EventKafkaEventListener<T>
implements AcknowledgingMessageListener<String, String> {
    private static final Logger log = LoggerFactory.getLogger(EventKafkaEventListener.class);
    private Class<T> event;
    private String consumerGroup;
    private KafkaEventMessageHandler<T> handler;
    @Autowired(required=false)
    private AbstractMessageStore messageStore;
    @Autowired
    private SysConfig sysConfig;

    public void onMessage(ConsumerRecord<String, String> consumerRecord, Acknowledgment acknowledgment) {
        block5: {
            T eventMessage = JsonHelper.resolve((String)consumerRecord.value(), this.event);
            EventMessage message = this.event.getAnnotation(EventMessage.class);
            Map map = JsonHelper.resolve((String)consumerRecord.value(), Map.class);
            String uuid = (String)map.get("uuid_");
            try {
                if (this.enableHandle((String)consumerRecord.value())) {
                    this.handler.handle(eventMessage);
                    acknowledgment.acknowledge();
                    if (KafkaAckType.AUTO.equals((Object)message.ackType()) || KafkaAckType.RPC.equals((Object)message.ackType())) {
                        this.ackMessage(consumerRecord.topic(), consumerRecord.offset(), uuid, message.ackType());
                    } else {
                        log.debug("\u65e0\u9700\u786e\u8ba4\u7684\u6d88\u606f:{},\u5df2\u88ab\u5904\u7406!", (Object)uuid);
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                log.error(throwable.getMessage());
                if (!KafkaAckType.AUTO.equals((Object)message.ackType())) break block5;
                this.messageStore.retryMessage(consumerRecord.offset(), uuid, consumerRecord.topic(), this.getConsumerGroup(), message.maxAckCount());
            }
        }
    }

    private boolean enableHandle(String value) {
        Map map = JsonHelper.resolve(value, Map.class);
        Object group = map.get("consumerGroup_");
        if (group == null) {
            return true;
        }
        return group.toString().equals(this.consumerGroup);
    }

    private void ackMessage(String completeTopic, long offSet, String uuid, KafkaAckType ackType) {
        if (this.messageStore == null) {
            log.error("\u60a8\u672a\u914d\u7f6emessageStore\u6d88\u606f\u5c06\u4e0d\u4f1a\u88ab\u786e\u8ba4!");
        } else {
            this.messageStore.ackDeal(completeTopic, offSet, uuid, this.getConsumerGroup(), ackType);
        }
    }

    public Class<T> getEvent() {
        return this.event;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public AbstractMessageStore getMessageStore() {
        return this.messageStore;
    }

    public SysConfig getSysConfig() {
        return this.sysConfig;
    }

    public void setEvent(Class<T> event) {
        this.event = event;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public void setMessageStore(AbstractMessageStore messageStore) {
        this.messageStore = messageStore;
    }

    public void setSysConfig(SysConfig sysConfig) {
        this.sysConfig = sysConfig;
    }

    public KafkaEventMessageHandler<T> getHandler() {
        return this.handler;
    }

    public void setHandler(KafkaEventMessageHandler<T> handler) {
        this.handler = handler;
    }
}

