/*
 * Decompiled with CFR 0.152.
 */
package cn.shazhengbo.kafka.event;

import cn.shazhengbo.kafka.annotation.EventMessage;
import cn.shazhengbo.kafka.annotation.EventMessageListener;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ContainerProperties;

public abstract class ServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(ServiceHelper.class);

    public static <T> EventMessage retrieveLeopardMessage(Class<T> clazz) {
        EventMessage leopardMessage = clazz.getAnnotation(EventMessage.class);
        if (leopardMessage == null) {
            log.error(String.format("\u6d88\u606f\u3010%s\u3011\u672a\u8fdb\u884cEventMessage\u6ce8\u89e3", clazz.getName()));
        }
        return leopardMessage;
    }

    public static <T> EventMessageListener retrieveMessageListener(Class<T> clazz) {
        EventMessageListener messageListener = clazz.getAnnotation(EventMessageListener.class);
        if (messageListener == null) {
            log.error(String.format("\u6d88\u606f\u5904\u7406\u5668\u3010%s\u3011\u672a\u8fdb\u884cEventMessageListener\u6ce8\u89e3", clazz.getName()));
        }
        return messageListener;
    }

    public static ConcurrentMessageListenerContainer<String, String> createListenerContainer(EventMessageListener annotation, String topic, ConsumerFactory consumerFactory, Object messageListener) {
        ContainerProperties containerProperties = new ContainerProperties(new String[]{topic});
        containerProperties.setGroupId(annotation.group());
        containerProperties.setAckMode(ContainerProperties.AckMode.MANUAL_IMMEDIATE);
        containerProperties.setPollTimeout(annotation.maxPollIntervalMs());
        containerProperties.setMessageListener(messageListener);
        Properties kafkaConsumerProperties = new Properties();
        kafkaConsumerProperties.setProperty("max.poll.records", String.valueOf(annotation.maxPollRecords()));
        kafkaConsumerProperties.setProperty("max.poll.interval.ms", String.valueOf(annotation.maxPollIntervalMs()));
        kafkaConsumerProperties.setProperty("enable.auto.commit", String.valueOf(false));
        kafkaConsumerProperties.setProperty("request.timeout.ms", String.valueOf(annotation.requestTimeoutMs()));
        kafkaConsumerProperties.setProperty("auto.commit.interval.ms", String.valueOf(annotation.commitIntervalMs()));
        containerProperties.setKafkaConsumerProperties(kafkaConsumerProperties);
        ConcurrentMessageListenerContainer container = new ConcurrentMessageListenerContainer(consumerFactory, containerProperties);
        container.setAutoStartup(false);
        container.setBeanName(String.format("%s-%s", topic, annotation.group()));
        return container;
    }
}

