/*
 * Decompiled with CFR 0.152.
 */
package cn.shazhengbo.kafka.utils.time;

import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class TimeUtils {
    private static final Logger logger = LoggerFactory.getLogger(TimeUtils.class);
    private static final String SLASH_SEGMENTATION = "/";
    private static final String HORIZONTAL_PARTITIONING = "-";

    public static LocalDate strToLocalDate(String date) {
        return TimeUtils.strToLocalDate(date, "yyyy-MM-dd");
    }

    public static LocalDate strToLocalDate(String date, String pattern) {
        if (StringUtils.isEmpty((Object)date)) {
            return null;
        }
        return LocalDate.parse(date, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDate autoStrToLocalDate(String date) {
        if (StringUtils.isEmpty((Object)date)) {
            return null;
        }
        String strDate = date.trim().split(" ")[0];
        return TimeUtils.strToLocalDateTime(strDate, TimeUtils.getPatternDate(strDate));
    }

    public static LocalDate strToLocalDateTime(String dateTime, String pattern) {
        if (StringUtils.isEmpty((Object)dateTime)) {
            return null;
        }
        LocalDate localDate = LocalDate.parse(dateTime, DateTimeFormatter.ofPattern(pattern.trim()));
        return LocalDate.of(localDate.getYear(), localDate.getMonth().getValue(), localDate.getDayOfMonth());
    }

    public static int diffDays(LocalDate startDate, LocalDate endDate) {
        return Period.between(startDate, endDate).getDays();
    }

    public static String getPatternDate(String date) {
        StringBuilder patternDate = new StringBuilder();
        try {
            if (StringUtils.isEmpty((Object)date)) {
                return "";
            }
            String splitCharacter = "";
            String[] dataArr = null;
            if (date.contains(HORIZONTAL_PARTITIONING)) {
                splitCharacter = HORIZONTAL_PARTITIONING;
                dataArr = date.split(splitCharacter);
            } else if (date.contains(SLASH_SEGMENTATION)) {
                splitCharacter = SLASH_SEGMENTATION;
                dataArr = date.split(splitCharacter);
            } else {
                throw new Exception("\u76ee\u524d\u4e0d\u652f\u6301\u8be5\u65e5\u671f\u683c\u5f0f\u83b7\u53d6!");
            }
            if (dataArr.length > 0) {
                dataArr = date.split(splitCharacter);
                patternDate.append(TimeUtils.getArrayChar(dataArr[0].length(), "y").append(splitCharacter).toString());
                patternDate.append(TimeUtils.getArrayChar(dataArr[1].length(), "M").append(splitCharacter).toString());
                patternDate.append(TimeUtils.getArrayChar(dataArr[2].length(), "d").toString());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return patternDate.toString();
    }

    private static StringBuilder getArrayChar(int len, String character) {
        StringBuilder builder = new StringBuilder();
        for (int n = 0; n < len; ++n) {
            builder.append(character);
        }
        return builder;
    }
}

