/*
 * Decompiled with CFR 0.152.
 */
package cn.shazhengbo.kafka.utils.json;

import cn.shazhengbo.kafka.utils.TrimStringDeserializer;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonHelper {
    public static ObjectMapper OBJECT_MAPPER;
    private static final Logger LOGGER;

    public static <T> T clone(T source) {
        Object cloned;
        if (source == null) {
            return null;
        }
        try {
            cloned = OBJECT_MAPPER.readerFor(source.getClass()).readValue(OBJECT_MAPPER.writeValueAsString(source));
        }
        catch (IOException ex) {
            throw new RuntimeException("json\u5e8f\u5217\u5316\u6216\u53cd\u5e8f\u5217\u5316\u5f02\u5e38", ex);
        }
        return (T)cloned;
    }

    public static String stringify(Object object) {
        String json;
        if (object == null) {
            return "";
        }
        try {
            json = OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (Exception ex) {
            throw new RuntimeException("json\u5e8f\u5217\u5316\u5f02\u5e38", ex);
        }
        return json;
    }

    public static <T> T resolve(String json, Class<T> clazz) {
        Object obj;
        try {
            obj = OBJECT_MAPPER.readerFor(clazz).readValue(json);
        }
        catch (Exception e) {
            throw new RuntimeException("json\u53cd\u5e8f\u5217\u5316\u5f02\u5e38", e);
        }
        return (T)obj;
    }

    public static <T> T resolve(InputStream stream, Class<T> clazz) {
        Object obj;
        try {
            obj = OBJECT_MAPPER.readerFor(clazz).readValue(stream);
        }
        catch (IOException ex) {
            throw new RuntimeException("\u89e3\u6790\u5931\u8d25", ex);
        }
        return (T)obj;
    }

    public static <T> List<T> resolve(String json, Class<T> itemClass, Function<String, T> converter) {
        ArrayList result = new ArrayList();
        try {
            List list = (List)OBJECT_MAPPER.readerFor(List.class).readValue(json);
            list.forEach(l -> result.add(converter.apply(l.toString())));
        }
        catch (IOException ex) {
            throw new RuntimeException("\u89e3\u6790\u5931\u8d25", ex);
        }
        return result;
    }

    public static <S, T> T convert(S source, Class<T> clazz) {
        if (source == null) {
            return null;
        }
        return JsonHelper.resolve(JsonHelper.stringify(source), clazz);
    }

    static {
        LOGGER = LoggerFactory.getLogger(JsonHelper.class);
        OBJECT_MAPPER = new ObjectMapper();
        OBJECT_MAPPER.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(String.class, (JsonDeserializer)new TrimStringDeserializer());
        OBJECT_MAPPER.registerModule((Module)simpleModule);
    }
}

