/*
 * Decompiled with CFR 0.152.
 */
package cn.shazhengbo.kafka.utils.aop;

import java.lang.reflect.Field;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;

public abstract class AopTargetUtils {
    public static <T> T getTarget(T proxy) {
        T target;
        if (!AopUtils.isAopProxy(proxy)) {
            return proxy;
        }
        try {
            target = AopUtils.isJdkDynamicProxy(proxy) ? AopTargetUtils.getJdkDynamicProxyTargetObject(proxy) : AopTargetUtils.getCglibProxyTargetObject(proxy);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return target;
    }

    private static <T> T getCglibProxyTargetObject(T proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        return (T)((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
    }

    private static <T> T getJdkDynamicProxyTargetObject(T proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        return (T)((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
    }
}

