/*
 * Decompiled with CFR 0.152.
 */
package cn.shazhengbo.kafka.message;

import cn.shazhengbo.kafka.annotation.EventMessage;
import cn.shazhengbo.kafka.config.SysConfig;
import cn.shazhengbo.kafka.utils.json.JsonHelper;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
public class EventMessageTemplate {
    private final KafkaTemplate<String, String> kafkaTemplate;
    private final SysConfig sysConfig;

    public EventMessageTemplate(KafkaTemplate<String, String> kafkaTemplate, SysConfig sysConfig) {
        this.kafkaTemplate = kafkaTemplate;
        this.sysConfig = sysConfig;
    }

    public void sendMessage(Object object, Class<?> clazz) {
        EventMessage message = clazz.getAnnotation(EventMessage.class);
        this.kafkaTemplate.send(String.format("%s.%s", this.sysConfig.getTopicPrefix(), message.topic()), (Object)JsonHelper.stringify(object));
    }
}

