/*
 * Decompiled with CFR 0.152.
 */
package cn.shazhengbo.kafka.event.listener;

import cn.shazhengbo.kafka.message.EventMessageHandler;
import cn.shazhengbo.kafka.utils.json.JsonHelper;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class EventKafkaEventListener<T>
implements MessageListener<String, String> {
    private static final Logger log = LoggerFactory.getLogger(EventKafkaEventListener.class);
    private Class<T> event;
    private String consumerGroup;
    private EventMessageHandler<T> handler;

    public void onMessage(ConsumerRecord<String, String> consumerRecord) {
        T eventMessage = JsonHelper.resolve((String)consumerRecord.value(), this.event);
        try {
            this.handler.handle(eventMessage);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public Class<T> getEvent() {
        return this.event;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setEvent(Class<T> event) {
        this.event = event;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public EventMessageHandler<T> getHandler() {
        return this.handler;
    }

    public void setHandler(EventMessageHandler<T> handler) {
        this.handler = handler;
    }
}

