package cn.shazhengbo

import cn.shazhengbo.mapper.TableMapper
import cn.shazhengbo.utils.GenUtils
import org.apache.commons.configuration.PropertiesConfiguration
import org.apache.ibatis.io.Resources
import org.apache.ibatis.session.SqlSession
import org.apache.ibatis.session.SqlSessionFactory
import org.apache.ibatis.session.SqlSessionFactoryBuilder

class Demo {

    static void main(String[] args) {
        String resource = "mybatis-configuartion.xml"
        InputStream inputStream = Resources.getResourceAsStream(resource)
        SqlSessionFactory sqlSessionFactory = new SqlSessionFactoryBuilder().build(inputStream)
        SqlSession session = sqlSessionFactory.openSession()
        def tableMapper = session.getMapper(TableMapper.class)

        /**
         * 需要自动生成代码的表名
         */
        def tableNames = ['project_progress'] as String[]
        /**
         * 生成代码
         */
        GenUtils.generatorCode(tableMapper, tableNames, new PropertiesConfiguration("generator.properties"))
    }


}
