/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.springo.core.sms;

import cn.sexycode.springo.core.base.core.util.AppUtil;
import cn.sexycode.springo.core.base.core.util.SoapUtil;
import cn.sexycode.springo.core.base.core.util.string.StringUtil;
import cn.sexycode.springo.core.sms.IShortMessage;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ShortMessageImpl
implements IShortMessage {
    private static ShortMessageImpl instance;
    private static Lock lock;
    private Properties configproperties;
    private String url;
    private String userID;
    private String account;
    private String password;
    private String content = "";
    private String sendTime;
    private int sendType;
    private String postFixNumber;
    private int sign;

    public static ShortMessageImpl getInstance() {
        if (instance != null) {
            return instance;
        }
        lock.lock();
        try {
            if (instance == null) {
                instance = new ShortMessageImpl();
            }
            instance.setConfigproperties((Properties)AppUtil.getBean((String)"configproperties"));
        }
        finally {
            lock.unlock();
        }
        return instance;
    }

    public void initial() {
        this.url = (String)this.configproperties.get("smsUrl");
        this.userID = (String)this.configproperties.get("userID");
        this.account = (String)this.configproperties.get("smsAccount");
        this.password = (String)this.configproperties.get("smsPassword");
        this.content = (String)this.configproperties.get("smsContent");
        this.sendTime = (String)this.configproperties.get("smsSendTime");
        this.sendType = Integer.parseInt((String)this.configproperties.get("smssendType"));
        this.postFixNumber = (String)this.configproperties.get("smsPostFixNumber");
        this.sign = Integer.parseInt((String)this.configproperties.get("smsSign"));
    }

    @Override
    public boolean sendSms(List<String> mobiles, String message) {
        this.initial();
        String envelop = this.generateEnvelop(mobiles, message);
        Map map = SoapUtil.getResponse((String)this.url, (String)envelop);
        return (Boolean)map.get("success");
    }

    private String generateEnvelop(List<String> mobiles, String content) {
        String phones = StringUtil.convertCollectionAsString(mobiles);
        String wsdlStr = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:soap=\"http://soap.sms.com\"><soapenv:Header/><soapenv:Body><soap:directSend><soap:userID>" + this.userID + "</soap:userID>" + "<soap:account>" + this.account + "</soap:account>" + "<soap:password>" + this.password + "</soap:password>" + "<soap:phones>" + phones + "</soap:phones>" + "<soap:content>" + content + "</soap:content>" + "<soap:sendTime>" + this.sendTime + "</soap:sendTime>" + "<soap:sendType>" + this.sendType + "</soap:sendType>" + "<soap:postFixNumber>" + this.postFixNumber + "</soap:postFixNumber>" + "<soap:sign>" + this.sign + "</soap:sign>" + "</soap:directSend>" + "</soapenv:Body>" + "</soapenv:Envelope>";
        return wsdlStr;
    }

    public void setConfigproperties(Properties configproperties) {
        this.configproperties = configproperties;
    }

    static {
        lock = new ReentrantLock();
    }
}

