/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.springo.core.sms;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModemMessagePort {
    public static final int PACKET_LENGTH = 500;
    private static ModemMessagePort port;
    private static Lock lock;
    protected Log logger = LogFactory.getLog(ModemMessagePort.class);
    SerialPort serialPort;
    CommPortIdentifier identifier;
    String PortName;
    OutputStream out;
    InputStream in;
    String appname = "SerialBean";
    int timeOut;
    int baudrate;
    int dataBits;
    int stopBits;
    int parity;

    private ModemMessagePort() {
    }

    public static ModemMessagePort getInstance() {
        if (port == null) {
            lock.lock();
            try {
                if (port == null) {
                    port = new ModemMessagePort();
                }
            }
            finally {
                lock.unlock();
            }
        }
        return port;
    }

    public void setAppname(String appname) {
        this.appname = appname;
    }

    public void initialize(int timeOut, int baudrate, int dataBits, int stopBits, int parity) {
        this.timeOut = timeOut;
        this.baudrate = baudrate;
        this.dataBits = dataBits;
        this.stopBits = stopBits;
        this.parity = parity;
    }

    public boolean openPort(String portName) {
        boolean rsBool = false;
        this.PortName = portName;
        try {
            this.identifier = this.getCommPort();
            if (this.identifier != null && !this.identifier.isCurrentlyOwned()) {
                this.serialPort = (SerialPort)this.identifier.open(this.appname, this.timeOut);
                this.in = this.serialPort.getInputStream();
                this.out = this.serialPort.getOutputStream();
                this.serialPort.setSerialPortParams(this.baudrate, this.dataBits, this.stopBits, this.parity);
                this.serialPort.setDTR(true);
                this.serialPort.setRTS(true);
                rsBool = true;
            }
        }
        catch (PortInUseException portInUseException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsBool;
    }

    public CommPortIdentifier getCommPort() throws Exception {
        CommPortIdentifier portIdRs = null;
        portIdRs = CommPortIdentifier.getPortIdentifier((String)this.PortName);
        return portIdRs;
    }

    public char[] readPackData() throws Exception {
        byte[] readBuffer = new byte[500];
        char[] msgPack = null;
        int numBytes = 0;
        while (this.in.available() > 0) {
            numBytes = this.in.read(readBuffer);
            msgPack = null;
            msgPack = new char[numBytes];
            for (int i = 0; i < numBytes; ++i) {
                msgPack[i] = (char)(readBuffer[i] & 0xFF);
            }
        }
        return msgPack;
    }

    public void writePort(char[] bytes) throws IOException {
        for (char b : bytes) {
            this.writePort(b);
        }
    }

    public void writePort(char b) throws IOException {
        this.out.write(b);
        this.out.flush();
    }

    public void closePort() {
        if (this.out != null) {
            try {
                this.out.close();
                this.in.close();
                this.out = null;
                this.in = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.serialPort != null) {
            this.serialPort.close();
            this.serialPort = null;
        }
    }

    public List<String> getAllComPorts() {
        ArrayList<String> comList = new ArrayList<String>();
        this.logger.info((Object)"[sms]\u51c6\u5907\u83b7\u53d6\u6240\u6709\u7aef\u53e3\u2026");
        Enumeration en = CommPortIdentifier.getPortIdentifiers();
        CommPortIdentifier portIdRs = null;
        while (en.hasMoreElements()) {
            portIdRs = (CommPortIdentifier)en.nextElement();
            if (portIdRs.getPortType() != 1) continue;
            comList.add(portIdRs.getName());
        }
        this.logger.info((Object)("[sms]\u83b7\u53d6\u5230:" + comList.size() + "\u4e2a\u7aef\u53e3"));
        return comList;
    }

    static {
        lock = new ReentrantLock();
    }
}

