/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.springo.core.sms;

import cn.sexycode.springo.core.sms.ModemMessagePort;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.smslib.helper.SerialPort;

public class ModemMessageOperator {
    protected static Log logger = LogFactory.getLog(ModemMessageOperator.class);
    private static ModemMessageOperator instance;
    private static ModemMessagePort messagePort;
    private static Lock lock;
    int portId;
    int baudrate;
    int timeOut;
    int dataBits;
    int stopBits;
    int parity;
    int funCode;
    int dataLen;
    int appendMillsec;
    int bytes;
    int frameInterval;

    private ModemMessageOperator() {
        messagePort = ModemMessagePort.getInstance();
        this.timeOut = 60;
        this.baudrate = 9600;
        this.dataBits = SerialPort.DATABITS_8;
        this.stopBits = SerialPort.STOPBITS_1;
        this.parity = SerialPort.PARITY_NONE;
        this.funCode = 3;
        this.dataLen = 4;
        this.appendMillsec = 38;
        this.bytes = 20;
    }

    public static ModemMessageOperator getInstance() {
        if (instance != null) {
            return instance;
        }
        lock.lock();
        try {
            if (instance == null) {
                instance = new ModemMessageOperator();
            }
        }
        catch (Exception ex) {
            logger.info((Object)("[sms]error:" + ex.getMessage()));
        }
        finally {
            lock.unlock();
        }
        return instance;
    }

    public static int getFrameInterval(int appendMillsec, int dataLen, int baudrate) {
        int rsInt = (int)Math.ceil((float)(12 * (dataLen + 4) * 1000) / (float)baudrate) + appendMillsec;
        return rsInt;
    }

    public static final String bytesToHexString(char[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        String sTemp = "";
        for (int i = 0; i < bArray.length; ++i) {
            sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase() + " ");
        }
        return sb.toString();
    }

    public boolean openPort(String portStr, int baudrate, String appName) {
        boolean rsBool = false;
        messagePort.initialize(this.timeOut, baudrate, this.dataBits, this.stopBits, this.parity);
        messagePort.setAppname(appName.toUpperCase());
        if (messagePort.openPort(portStr)) {
            rsBool = true;
            this.frameInterval = ModemMessageOperator.getFrameInterval(this.appendMillsec, this.bytes, baudrate);
        }
        return rsBool;
    }

    public void writeByte(char[] rs) throws Exception {
        messagePort.writePort(rs);
        Thread.sleep(this.frameInterval);
    }

    public boolean readByte(String portStr) throws Exception {
        boolean rsbool = false;
        String rsStr = "";
        char[] rsByte = messagePort.readPackData();
        if (rsByte != null) {
            for (char c : rsByte) {
                rsStr = rsStr + c;
            }
            if (rsStr.indexOf("OK") > 0) {
                logger.info((Object)("\u627e\u5230" + portStr + ":\u77ed\u4fe1\u6a21\u5757\u4e32\u53e3"));
                rsbool = true;
            }
        } else {
            logger.info((Object)(portStr + ":\u4e0d\u662f\u77ed\u4fe1\u6a21\u5757\u4e32\u53e3"));
        }
        return rsbool;
    }

    public String getRightComStr() {
        String rightCom = null;
        List<String> portList = messagePort.getAllComPorts();
        if (portList.size() > 0) {
            for (String portStr : portList) {
                if (!this.testSms(portStr)) continue;
                rightCom = portStr;
                break;
            }
        }
        return rightCom;
    }

    private boolean testSms(String portStr) {
        boolean rsBool = false;
        try {
            rsBool = instance.openPort(portStr, this.baudrate, "sms_port");
            String atCommand = "AT\r";
            char[] atOrder = atCommand.toCharArray();
            if (rsBool) {
                instance.writeByte(atOrder);
            }
            if (rsBool) {
                rsBool = instance.readByte(portStr);
                instance.closePort();
            }
        }
        catch (Exception e) {
            rsBool = false;
            e.printStackTrace();
        }
        return rsBool;
    }

    public void closePort() {
        messagePort.closePort();
    }

    static {
        lock = new ReentrantLock();
    }
}

