/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.springo.core.sms;

import cn.sexycode.springo.core.sms.IShortMessage;
import cn.sexycode.springo.core.sms.ModemMessageOperator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.Message;
import org.smslib.OutboundMessage;
import org.smslib.Service;
import org.smslib.modem.SerialModemGateway;

public class ModemMessageImpl
implements IShortMessage {
    private static ModemMessageImpl instance = null;
    private static Lock lock = new ReentrantLock();
    private static String smsGroup = "smsgruop";
    protected Logger logger = LoggerFactory.getLogger(ModemMessageImpl.class);
    private boolean serviceHasOpen = false;
    private Service srv = null;
    private SerialModemGateway gateway;

    public static ModemMessageImpl getInstance() {
        if (instance == null) {
            lock.lock();
            try {
                if (instance == null) {
                    instance = new ModemMessageImpl();
                }
            }
            finally {
                lock.unlock();
            }
        }
        return instance;
    }

    private boolean initial(String com, int baudRate, String pin) {
        boolean rsbool = true;
        this.srv = new Service();
        this.gateway = new SerialModemGateway("SMSLINK", com, baudRate, "", "");
        this.gateway.setOutbound(true);
        this.gateway.setInbound(true);
        this.gateway.setProtocol(AGateway.Protocols.PDU);
        this.gateway.setSimPin(pin);
        try {
            this.srv.addGateway((AGateway)this.gateway);
        }
        catch (GatewayException e) {
            rsbool = false;
            e.printStackTrace();
        }
        if (rsbool) {
            rsbool = this.startService();
        }
        return rsbool;
    }

    private boolean sendMessage(List<String> phoneList, String message) {
        boolean rsbool = true;
        for (String string : phoneList) {
            this.srv.addToGroup(smsGroup, string);
        }
        OutboundMessage msg = new OutboundMessage(smsGroup, message);
        msg.setEncoding(Message.MessageEncodings.ENCUCS2);
        try {
            this.srv.sendMessage(msg);
            for (String phone : phoneList) {
                this.srv.removeFromGroup(smsGroup, phone);
            }
        }
        catch (Exception exception) {
            rsbool = false;
            exception.printStackTrace();
        }
        return rsbool;
    }

    private boolean startService() {
        boolean rsbool = true;
        try {
            this.srv.startService();
            this.srv.createGroup(smsGroup);
        }
        catch (Exception e) {
            rsbool = false;
            e.printStackTrace();
        }
        return rsbool;
    }

    public boolean stopService() {
        boolean rsbool = true;
        try {
            if (this.srv != null) {
                this.srv.stopService();
                this.serviceHasOpen = false;
            }
        }
        catch (Exception e) {
            rsbool = false;
            e.printStackTrace();
        }
        return rsbool;
    }

    @Override
    public boolean sendSms(List<String> mobiles, String message) {
        if (this.serviceHasOpen) {
            return this.sendMessage(mobiles, message);
        }
        String comStr = ModemMessageOperator.getInstance().getRightComStr();
        if (comStr == null) {
            this.logger.info("[SMS]\u672a\u80fd\u83b7\u53d6\u5230\u53ef\u4ee5\u53d1\u9001\u77ed\u4fe1\u7684\u4e32\u53e3\u3002");
        }
        this.logger.info("[SMS]\u5f00\u59cb\u4f7f\u7528\u4e32\u53e3:" + comStr + "\u53d1\u9001\u77ed\u4fe1\u3002");
        if (comStr != null) {
            if (this.initial(comStr, 9600, "0000")) {
                this.serviceHasOpen = true;
                return this.sendMessage(mobiles, message);
            }
            return false;
        }
        return false;
    }
}

