/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.springo.query.util;

import cn.sexycode.springo.core.base.core.util.string.StringUtil;
import cn.sexycode.springo.core.base.core.util.string.StringValidator;

public class SqlDateFormatUtil {
    public static String convertDateFormat(String format, String value, String dbType) {
        if ("oracle".equals(dbType)) {
            return SqlDateFormatUtil.convertToOracle(format, value);
        }
        if ("mysql".equals(dbType)) {
            return SqlDateFormatUtil.convertToMySql(format, value);
        }
        if ("mssql".equals(dbType)) {
            return SqlDateFormatUtil.convertToMsSql(format, value);
        }
        return value;
    }

    private static String convertToOracle(String format, String value) {
        if (StringUtil.isEmpty((String)format)) {
            format = "yyyy-MM-dd";
        }
        format = format.replace("HH", "hh24");
        format = format.replace("mm", "mi");
        String rtn = " TO_DATE('" + value + "','" + format + "')";
        return rtn;
    }

    private static String convertToMySql(String format, String value) {
        if (StringValidator.isEmail((String)format)) {
            format = "%Y-%m-%d";
        }
        format = format.replace("yyyy", "%Y");
        format = format.replace("MM", "%m");
        format = format.replace("dd", "%d");
        format = format.replace("HH", "%H");
        format = format.replace("hh", "%h");
        format = format.replace("mm", "%i");
        format = format.replace("ss", "%s");
        String rtn = " STR_TO_DATE('" + value + "','" + format + "')";
        return rtn;
    }

    private static String convertToMsSql(String format, String value) {
        return " cast('" + value + "' as datetime) ";
    }
}

