/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.springo.query.util;

import cn.sexycode.springo.core.base.core.engine.script.GroovyScriptEngine;
import cn.sexycode.springo.core.base.core.util.AppUtil;
import cn.sexycode.springo.core.base.core.util.string.StringUtil;
import cn.sexycode.springo.query.util.FilterJsonStruct;
import cn.sexycode.springo.query.util.SqlDateFormatUtil;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FilterJsonStructUtil {
    public static String CONDITION_AND = "and";

    public static String getSql(String filterJson, String dbType) {
        if (StringUtil.isEmpty((String)filterJson)) {
            return "";
        }
        ArrayList<Map<String, Object>> operatorList = new ArrayList<Map<String, Object>>();
        List filters = JSONArray.parseArray((String)filterJson, FilterJsonStruct.class);
        FilterJsonStructUtil.getFilterResult(filters, operatorList, dbType);
        return FilterJsonStructUtil.executeOperator(operatorList);
    }

    private static void getFilterResult(List<FilterJsonStruct> filters, List<Map<String, Object>> operatorList, String dbType) {
        for (FilterJsonStruct filter : filters) {
            if (filter.getBranch().booleanValue()) {
                ArrayList<Map<String, Object>> branchResultList = new ArrayList<Map<String, Object>>();
                FilterJsonStructUtil.getFilterResult(filter.getSub(), branchResultList, dbType);
                String branchResult = FilterJsonStructUtil.executeOperator(branchResultList);
                Map<String, Object> resultMap = FilterJsonStructUtil.getResultMap(filter.getCompType(), branchResult);
                operatorList.add(resultMap);
                continue;
            }
            FilterJsonStructUtil.getNormalFilterResult(filter, operatorList, dbType);
        }
    }

    private static String executeOperator(List<Map<String, Object>> operatorList) {
        if (operatorList.size() == 0) {
            return "";
        }
        String returnVal = (String)operatorList.get(0).get("result");
        if (operatorList.size() == 1) {
            return returnVal;
        }
        int size = operatorList.size();
        for (int k = 1; k < size; ++k) {
            Map<String, Object> resultMap = operatorList.get(k);
            String operator = resultMap.get("operator").toString();
            if ("or".equals(operator)) {
                returnVal = "(" + returnVal + ") OR (" + resultMap.get("result") + ")";
                continue;
            }
            if (!"and".equals(operator)) continue;
            returnVal = "(" + returnVal + ") AND (" + resultMap.get("result") + ")";
        }
        if (StringUtil.isNotEmpty((String)returnVal)) {
            returnVal = "(" + returnVal + ")";
        }
        return returnVal;
    }

    private static Map<String, Object> getResultMap(String operator, String result) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("operator", operator);
        resultMap.put("result", result);
        return resultMap;
    }

    private static void getNormalFilterResult(FilterJsonStruct filter, List<Map<String, Object>> operatorList, String dbType) {
        String flowvarKey = filter.getFlowvarKey();
        String judgeVal1 = FilterJsonStructUtil.getJudgeVal(filter, true);
        String judgeVal2 = FilterJsonStructUtil.getJudgeVal(filter, false);
        int optType = filter.getOptType();
        String script = "";
        switch (optType) {
            case 1: {
                if (StringUtil.isNotEmpty((String)judgeVal1)) {
                    script = FilterJsonStructUtil.getCompareScript(filter.getJudgeCon1(), flowvarKey, judgeVal1, filter.getOptType());
                }
                if (!StringUtil.isNotEmpty((String)judgeVal2)) break;
                String moreScript = FilterJsonStructUtil.getCompareScript(filter.getJudgeCon2(), flowvarKey, judgeVal2, filter.getOptType());
                if (StringUtil.isNotEmpty((String)script)) {
                    script = script + CONDITION_AND;
                }
                script = script + moreScript;
                break;
            }
            case 2: {
                if (!StringUtil.isNotEmpty((String)judgeVal1)) break;
                script = FilterJsonStructUtil.getCompareScript(filter.getJudgeCon1(), flowvarKey, judgeVal1, filter.getOptType());
                break;
            }
            case 3: {
                if (StringUtil.isNotEmpty((String)judgeVal1)) {
                    String val1 = SqlDateFormatUtil.convertDateFormat(filter.getDatefmt(), judgeVal1, dbType);
                    script = FilterJsonStructUtil.getCompareScript(filter.getJudgeCon1(), flowvarKey, val1, filter.getOptType());
                }
                if (!StringUtil.isNotEmpty((String)judgeVal2)) break;
                String val2 = SqlDateFormatUtil.convertDateFormat(filter.getDatefmt(), judgeVal1, dbType);
                String moreScript = FilterJsonStructUtil.getCompareScript(filter.getJudgeCon2(), flowvarKey, val2, filter.getOptType());
                if (StringUtil.isNotEmpty((String)script)) {
                    script = script + CONDITION_AND;
                }
                script = script + moreScript;
                break;
            }
            case 4: {
                String[] vals;
                for (String val : vals = judgeVal1.split("&&")) {
                    if (StringUtil.isNotEmpty((String)script)) {
                        script = script + CONDITION_AND;
                    }
                    script = script + FilterJsonStructUtil.getCompareScript(filter.getJudgeCon1(), flowvarKey, val, filter.getOptType());
                }
                break;
            }
            case 5: {
                String judgeCon = filter.getJudgeCon1();
                String[] ids = judgeVal1.split("&&");
                if (ids.length == 2) {
                    script = FilterJsonStructUtil.getCompareScript(judgeCon, filter.getFlowvarKey(), ids[0], filter.getOptType());
                    break;
                }
                if (!"3".equalsIgnoreCase(judgeCon) && !"4".equalsIgnoreCase(judgeCon)) break;
                script = FilterJsonStructUtil.getCompareScript(judgeCon, filter.getFlowvarKey(), judgeVal1, filter.getOptType());
            }
        }
        if (StringUtil.isEmpty((String)script)) {
            return;
        }
        Map<String, Object> resultMap = FilterJsonStructUtil.getResultMap(filter.getCompType(), script);
        operatorList.add(resultMap);
    }

    private static String getJudgeVal(FilterJsonStruct filter, boolean isJudgeVal1) {
        String val = isJudgeVal1 ? filter.getJudgeVal1() : filter.getJudgeVal2();
        int ruleType = filter.getRuleType();
        if (ruleType == 1) {
            return val;
        }
        GroovyScriptEngine groovyScriptEngine = (GroovyScriptEngine)AppUtil.getBean(GroovyScriptEngine.class);
        String object = groovyScriptEngine.executeString(val, null);
        return object.toString();
    }

    private static String getCompareScript(String judgeCon, String fieldName, String judgeVal, int type) {
        StringBuffer sb = new StringBuffer();
        switch (type) {
            case 1: 
            case 3: {
                if ("1".equals(judgeCon)) {
                    sb.append(fieldName).append("=").append(judgeVal);
                    break;
                }
                if ("2".equals(judgeCon)) {
                    sb.append(fieldName).append("!=").append(judgeVal);
                    break;
                }
                if ("3".equals(judgeCon)) {
                    sb.append(fieldName).append(">").append(judgeVal);
                    break;
                }
                if ("4".equals(judgeCon)) {
                    sb.append(fieldName).append(">=").append(judgeVal);
                    break;
                }
                if ("5".equals(judgeCon)) {
                    sb.append(fieldName).append("<").append(judgeVal);
                    break;
                }
                if ("6".equals(judgeCon)) {
                    sb.append(fieldName).append("<=").append(judgeVal);
                    break;
                }
                if ("7".equals(judgeCon)) {
                    sb.append(fieldName).append(" = :").append("").append(judgeVal).append("");
                    break;
                }
                if (!"8".equals(judgeCon)) break;
                sb.append(fieldName).append(" != :").append("").append(judgeVal).append("");
                break;
            }
            case 2: 
            case 4: {
                if ("1".equals(judgeCon)) {
                    sb.append(fieldName).append("=").append("'").append(judgeVal).append("'");
                    break;
                }
                if ("2".equals(judgeCon)) {
                    sb.append(fieldName).append("!=").append("'").append(judgeVal).append("'");
                    break;
                }
                if ("3".equals(judgeCon)) {
                    sb.append("UPPER(").append(fieldName).append(")=").append(" UPPER('").append(judgeVal).append("')");
                    break;
                }
                if ("4".equals(judgeCon)) {
                    sb.append(fieldName).append(" LIKE").append(" '%").append(judgeVal).append("%'");
                    break;
                }
                if ("5".equals(judgeCon)) {
                    sb.append(fieldName).append(" LIKE").append(" '").append(judgeVal).append("%'");
                    break;
                }
                if ("6".equals(judgeCon)) {
                    sb.append(fieldName).append(" LIKE").append(" '%").append(judgeVal).append("'");
                    break;
                }
                if ("7".equals(judgeCon)) {
                    sb.append(fieldName).append(" = :").append("").append(judgeVal).append("");
                    break;
                }
                if (!"8".equals(judgeCon)) break;
                sb.append(fieldName).append(" != :").append("").append(judgeVal).append("");
                break;
            }
            case 5: {
                if ("1".equals(judgeCon)) {
                    sb.append(fieldName).append(" in (").append("").append(judgeVal).append(")");
                    break;
                }
                if ("2".equals(judgeCon)) {
                    sb.append(fieldName).append(" not in (").append("").append(judgeVal).append(")");
                    break;
                }
                if ("3".equals(judgeCon)) {
                    sb.append(fieldName).append(" = :").append("").append(judgeVal).append("");
                    break;
                }
                if (!"4".equals(judgeCon)) break;
                sb.append(fieldName).append(" != :").append("").append(judgeVal).append("");
            }
        }
        return sb.toString();
    }
}

