/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.springo.query.manager.impl;

import cn.sexycode.springo.core.base.api.var.IContextVar;
import cn.sexycode.springo.core.base.core.engine.script.GroovyScriptEngine;
import cn.sexycode.springo.core.base.core.json.DefaultJSONArray;
import cn.sexycode.springo.core.base.core.json.DefaultJSONObject;
import cn.sexycode.springo.core.base.core.json.JSONArray;
import cn.sexycode.springo.core.base.core.json.JSONObject;
import cn.sexycode.springo.core.base.core.util.AppUtil;
import cn.sexycode.springo.core.base.core.util.BeanUtils;
import cn.sexycode.springo.core.base.core.util.JsonUtil;
import cn.sexycode.springo.core.base.core.util.MapUtil;
import cn.sexycode.springo.core.base.core.util.string.StringUtil;
import cn.sexycode.springo.core.base.core.util.time.TimeUtil;
import cn.sexycode.springo.core.data.db.api.query.QueryOP;
import cn.sexycode.springo.core.data.db.api.sqlbuilder.ISqlBuilder;
import cn.sexycode.springo.core.data.db.api.sqlbuilder.SqlBuilderModel;
import cn.sexycode.springo.core.data.db.manager.impl.BaseManagerImpl;
import cn.sexycode.springo.core.data.db.mybatis.dao.CommonDao;
import cn.sexycode.springo.core.data.db.sqlbuilder.service.SqlBuilderService;
import cn.sexycode.springo.query.dao.QueryViewDao;
import cn.sexycode.springo.query.manager.QueryMetafieldManager;
import cn.sexycode.springo.query.manager.QuerySqldefManager;
import cn.sexycode.springo.query.manager.QueryViewManager;
import cn.sexycode.springo.query.model.QuerySqlDef;
import cn.sexycode.springo.query.model.QueryView;
import cn.sexycode.springo.query.util.FilterJsonStructUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;

public class QueryViewManagerImpl
extends BaseManagerImpl<QueryView>
implements QueryViewManager {
    @Resource
    QueryMetafieldManager queryMetafieldManager;
    @Resource
    CommonDao commonDao;
    @Resource
    private QueryViewDao queryViewDao;
    @Resource
    private QuerySqldefManager querySqldefManager;
    @Resource
    private GroovyScriptEngine groovyScriptEngine;
    @Resource
    private JdbcTemplate jdbcTemplate;
    @Resource
    private SqlBuilderService sqlBuilderService;

    @Override
    public List<QueryView> getBySqlAlias(String sqlAlias) {
        return this.queryViewDao.getBySqlAlias(sqlAlias);
    }

    @Override
    public void removeBySqlAlias(String sqlAlias) {
        this.queryViewDao.removeBySqlAlias(sqlAlias);
    }

    @Override
    public QueryView getBySqlAliasAndAlias(String sqlAlias, String alias) {
        return this.queryViewDao.getBySqlAliasAndAlias(sqlAlias, alias);
    }

    @Override
    public String getShowSql(QueryView queryView, Map<String, Object> queryParams) {
        if (queryView.getFilterType() == 2) {
            return this.executeScript(queryView.getFilter(), queryParams);
        }
        QuerySqlDef querySqldef = this.querySqldefManager.getByAlias(queryView.getSqlAlias());
        JSONArray conJA = JSONArray.parseArray((String)queryView.getConditions());
        StringBuilder sql = new StringBuilder();
        sql.append(querySqldef.getSql().replace(";", "")).append(" where 1=1 ");
        DefaultJSONArray conditionField = new DefaultJSONArray();
        this.handleFilter(queryView, (JSONArray)conditionField, queryParams);
        this.handleCondition(queryParams, conJA, (JSONArray)conditionField);
        String dbType = "mysql";
        SqlBuilderModel model = new SqlBuilderModel();
        model.setDbType(dbType);
        model.setConditionField((JSONArray)conditionField);
        ISqlBuilder sqlBuilder = this.sqlBuilderService.getSqlBuilder(model);
        String csql = sqlBuilder.analyzeConditionField();
        sql.append(csql);
        String sortField = MapUtil.getIgnoreCase(queryParams, (String)"sortField", (Object)"").toString();
        String orderSeq = MapUtil.getIgnoreCase(queryParams, (String)"orderSeq", (Object)"").toString();
        if (StringUtil.isNotEmpty((String)sortField)) {
            if (StringUtil.isNotEmpty((String)orderSeq)) {
                sql.append(" order by ").append(sortField).append(" ").append(orderSeq);
            } else {
                sql.append(" order by ").append(sortField.substring(0, sortField.length() - 1));
            }
        }
        return sql.toString();
    }

    private String executeScript(String script, Map<String, Object> param) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("param", param);
        vars.putAll(param);
        return this.groovyScriptEngine.executeString(this.replaceVar(script), vars);
    }

    private String replaceVar(String str) {
        List comVarList = (List)AppUtil.getBean((String)"queryViewComVarList");
        for (IContextVar c : comVarList) {
            str = str.replace("[" + c.getAlias() + "]", c.getValue());
        }
        return str;
    }

    @Override
    public void handleShowData(QueryView queryView, List list) {
        JSONArray showJA = JSONArray.parseArray((String)queryView.getShows());
        HashMap<String, Map<String, Object>> cacheMap = new HashMap<String, Map<String, Object>>();
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            HashMap<String, String> tmp = new HashMap<String, String>();
            for (int j = 0; j < showJA.size(); ++j) {
                JSONObject jo = showJA.getJSONObject(j);
                String fieldName = jo.getString("fieldName");
                if (!JsonUtil.getString((JSONObject)jo, (String)"hidden", (String)"0").equals("0")) continue;
                tmp.put(fieldName, MapUtil.getIgnoreCase((Map)map, (String)fieldName, (Object)"").toString());
                if (JsonUtil.getString((JSONObject)jo, (String)"isVirtual", (String)"0").equals("0")) continue;
                String con = MapUtil.getIgnoreCase((Map)map, (String)jo.getString("virtualFrom")) + "";
                String str = jo.getString("resultFrom").replace("#CON#", con);
                Object val = this.getValFromCache(cacheMap, fieldName, con);
                if (BeanUtils.isEmpty((Object)val)) {
                    if (jo.getString("resultFromType").equals("script")) {
                        val = this.groovyScriptEngine.executeString(str, new HashMap());
                    } else if (jo.getString("resultFromType").equals("sql")) {
                        Map m = this.jdbcTemplate.queryForMap(str);
                        val = m.keySet().stream().findFirst().map(m::get).orElse(val);
                    }
                    this.putValToCache(cacheMap, fieldName, con, val);
                }
                tmp.put(fieldName, val.toString());
            }
            list.set(i, tmp);
        }
    }

    private Object getValFromCache(Map<String, Map<String, Object>> cacheMap, String fieldName, String key) {
        Map<String, Object> map = cacheMap.get(fieldName);
        if (BeanUtils.isEmpty(map)) {
            return null;
        }
        return map.get(key);
    }

    private void putValToCache(Map<String, Map<String, Object>> cacheMap, String fieldName, String key, Object val) {
        Map<String, Object> map = cacheMap.get(fieldName);
        if (BeanUtils.isEmpty(map)) {
            map = new HashMap<String, Object>();
            cacheMap.put(fieldName, map);
        }
        map.put(key, val);
    }

    private void handleFilter(QueryView queryView, JSONArray conditionField, Map<String, Object> param) {
        String sql = "";
        if (queryView.getFilterType() == 3) {
            sql = this.executeScript(queryView.getFilter(), param);
        } else if (queryView.getFilterType() == 1) {
            QuerySqlDef querySqldef = this.querySqldefManager.getByAlias(queryView.getSqlAlias());
            String dbType = "mysql";
            sql = FilterJsonStructUtil.getSql(queryView.getFilter(), dbType);
        }
        if (StringUtil.isEmpty((String)sql)) {
            return;
        }
        DefaultJSONObject jo = new DefaultJSONObject();
        jo.put((Object)"isScript", (Object)"1");
        jo.put((Object)"value", (Object)(" and " + sql));
        conditionField.add((Object)jo);
    }

    private void handleCondition(Map<String, Object> queryParams, JSONArray conJA, JSONArray conditionField) {
        for (Object obj : conJA) {
            Object val;
            DefaultJSONObject jo;
            JSONObject con = (JSONObject)obj;
            String fieldName = con.getString("fieldName");
            String op = con.getString("operate");
            if (op.equals(QueryOP.BETWEEN.value())) {
                jo = new DefaultJSONObject();
                jo.put((Object)"start", queryParams.get("begin" + fieldName));
                if (con.getString("dataType").equals("date")) {
                    String end = queryParams.get("end" + fieldName) + "";
                    try {
                        end = TimeUtil.getNextDays((Date)TimeUtil.convertString((String)end, (String)"yyyy-MM-dd"), (int)1).toLocaleString();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    jo.put((Object)"end", (Object)end);
                } else {
                    jo.put((Object)"end", queryParams.get("end" + fieldName));
                }
                val = jo;
            } else {
                val = queryParams.get(fieldName);
            }
            if (BeanUtils.isEmpty((Object)val)) continue;
            jo = JSONObject.newJSONObject();
            jo.put((Object)"field", (Object)fieldName);
            jo.put((Object)"op", (Object)op);
            jo.put((Object)"dbType", (Object)con.getString("dataType"));
            jo.put((Object)"value", val);
            conditionField.add((Object)jo);
        }
    }

    private Map<String, Object> handleParam(Map<String, Object> queryParams) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        for (String key : queryParams.keySet()) {
            if (!key.startsWith("Q^")) continue;
            param.put(key.replace("Q^", ""), queryParams.get(key));
        }
        queryParams.putAll(param);
        return param;
    }
}

