/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.springo.query.manager.impl;

import cn.sexycode.springo.core.base.api.IModel;
import cn.sexycode.springo.core.base.core.enums.FieldControlType;
import cn.sexycode.springo.core.base.core.json.JSONObject;
import cn.sexycode.springo.core.base.core.util.AppUtil;
import cn.sexycode.springo.core.base.core.util.BeanUtils;
import cn.sexycode.springo.core.base.core.util.FileUtil;
import cn.sexycode.springo.core.base.core.util.JAXBUtil;
import cn.sexycode.springo.core.base.core.util.ThreadMsgUtil;
import cn.sexycode.springo.core.base.core.util.string.StringUtil;
import cn.sexycode.springo.core.data.db.api.query.QueryFilter;
import cn.sexycode.springo.core.data.db.api.query.QueryOP;
import cn.sexycode.springo.core.data.db.datasource.DataSourceUtil;
import cn.sexycode.springo.core.data.db.id.UniqueIdUtil;
import cn.sexycode.springo.core.data.db.manager.impl.BaseManagerImpl;
import cn.sexycode.springo.core.data.db.query.DefaultQueryFilter;
import cn.sexycode.springo.query.dao.QuerySqlDefDao;
import cn.sexycode.springo.query.dao.QueryViewDao;
import cn.sexycode.springo.query.manager.QueryMetafieldManager;
import cn.sexycode.springo.query.manager.QuerySqldefManager;
import cn.sexycode.springo.query.model.QueryMetaField;
import cn.sexycode.springo.query.model.QuerySqlDef;
import cn.sexycode.springo.query.model.QuerySqldefXml;
import cn.sexycode.springo.query.model.QuerySqldefXmlList;
import cn.sexycode.springo.query.model.QueryView;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;

public class QuerySqldefManagerImpl
extends BaseManagerImpl<QuerySqlDef>
implements QuerySqldefManager {
    @Resource
    private QuerySqlDefDao querySqldefDao;
    @Resource
    private QueryMetafieldManager queryMetafieldManager;
    @Resource
    private QueryViewDao queryViewDao;

    public void remove(String entityId) {
        QuerySqlDef querySqldef = (QuerySqlDef)this.get(entityId);
        this.queryMetafieldManager.removeBySqlId(entityId);
        this.queryViewDao.removeBySqlAlias(querySqldef.getAlias());
        super.remove(entityId);
    }

    @Override
    public JSONObject checkSql(String dsName, String sql) {
        JSONObject data = JSONObject.newJSONObject();
        JdbcTemplate jdbcTemplate = null;
        try {
            jdbcTemplate = (JdbcTemplate)AppUtil.getBean(JdbcTemplate.class);
            jdbcTemplate.execute(sql);
            data.put((Object)"result", (Object)true);
            data.put((Object)"message", (Object)"\u9a8c\u8bc1\u901a\u8fc7");
        }
        catch (Exception e) {
            data.put((Object)"result", (Object)false);
            data.put((Object)"message", (Object)e.getMessage());
        }
        throw new RuntimeException(data.toString());
    }

    public boolean save(QuerySqlDef querySqldef) {
        this.checkBeforeSave(querySqldef);
        if (StringUtil.isEmpty((String)querySqldef.getId())) {
            querySqldef.setId(UniqueIdUtil.getSuid());
            this.create((IModel)querySqldef);
            this.initMetafield(querySqldef);
        } else {
            this.update((IModel)querySqldef);
        }
        this.queryMetafieldManager.removeBySqlId(querySqldef.getId());
        for (QueryMetaField field : querySqldef.getMetaFields()) {
            field.setId(UniqueIdUtil.getSuid());
            this.queryMetafieldManager.create((Object)field);
        }
        return true;
    }

    private void checkBeforeSave(QuerySqlDef querySqldef) {
        if (!StringUtil.isEmpty((String)querySqldef.getId())) {
            return;
        }
        if (this.getByAlias(querySqldef.getAlias()) != null) {
            throw new RuntimeException("\u522b\u540d:" + querySqldef.getAlias() + ",\u5df2\u88ab\u4f7f\u7528");
        }
    }

    @Override
    public QuerySqlDef getByAlias(String alias) {
        DefaultQueryFilter queryFilter = new DefaultQueryFilter();
        queryFilter.addFilter("alias_", (Object)alias, QueryOP.EQUAL);
        List list = this.query((QueryFilter)queryFilter);
        if (list != null && !list.isEmpty()) {
            return (QuerySqlDef)((Object)list.get(0));
        }
        return null;
    }

    private void initMetafield(QuerySqlDef querySqldef) {
        ArrayList<QueryMetaField> list = new ArrayList<QueryMetaField>();
        JdbcTemplate jdbcTemplate = null;
        try {
            jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)querySqldef.getDsName());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
        SqlRowSet srs = jdbcTemplate.queryForRowSet(querySqldef.getSql());
        SqlRowSetMetaData srsmd = srs.getMetaData();
        for (int i = 1; i < srsmd.getColumnCount() + 1; ++i) {
            String cn = srsmd.getColumnName(i).toUpperCase();
            String ctn = srsmd.getColumnTypeName(i);
            QueryMetaField field = new QueryMetaField();
            field.setSqlId(querySqldef.getId());
            field.setName(cn);
            field.setFieldName(cn);
            field.setFieldDesc(cn);
            field.setIsShow((short)1);
            field.setIsSearch((short)0);
            field.setControlType(FieldControlType.ONETEXT.key);
            field.setIsVirtual((short)0);
            field.setWidth((short)0);
            field.setSn((short)i);
            list.add(field);
        }
        querySqldef.setMetaFields(list);
    }

    @Override
    public String export(List<String> idList) throws Exception {
        if (BeanUtils.isEmpty(idList)) {
            return "";
        }
        QuerySqldefXmlList list = new QuerySqldefXmlList();
        for (String id : idList) {
            QuerySqlDef def = (QuerySqlDef)((Object)this.querySqldefDao.selectById((Serializable)((Object)id)));
            List<QueryMetaField> metaFieldList = this.queryMetafieldManager.getBySqlId(id);
            List<QueryView> viewList = this.queryViewDao.getBySqlAlias(def.getAlias());
            QuerySqldefXml defXml = new QuerySqldefXml();
            defXml.setQuerySqldef(def);
            defXml.setMetafieldList(metaFieldList);
            defXml.setQueryViewList(viewList);
            list.addQuerySqlDef(defXml);
        }
        return JAXBUtil.marshall((Object)list, QuerySqldefXmlList.class);
    }

    @Override
    public void importDef(String path) {
        try {
            String xml = FileUtil.readFile((String)(path + File.separator + "sqldef.xml"));
            if (StringUtil.isEmpty((String)xml)) {
                return;
            }
            QuerySqldefXmlList list = (QuerySqldefXmlList)JAXBUtil.unmarshall((String)xml, QuerySqldefXmlList.class);
            List<QuerySqldefXml> sqlDefList = list.getQuerySqlDefList();
            for (QuerySqldefXml def : sqlDefList) {
                this.importDef(def);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u8868\u5355\u5bfc\u5165\u5931\u8d25" + e.getMessage(), e);
        }
    }

    private void importDef(QuerySqldefXml def) {
        QuerySqlDef sqlDef = def.getQuerySqldef();
        QuerySqlDef tmp = this.getByAlias(sqlDef.getAlias());
        if (tmp != null) {
            ThreadMsgUtil.addMsg((String)("\u5b9a\u4e49\uff1a" + tmp.getName() + "\uff0c\u5df2\u5b58\u5728\u6545\u8df3\u8fc7"));
            return;
        }
        String sqlId = UniqueIdUtil.getSuid();
        sqlDef.setId(sqlId);
        this.querySqldefDao.insert((Object)sqlDef);
        List<QueryMetaField> fieldList = sqlDef.getMetaFields();
        for (QueryMetaField field : fieldList) {
            field.setId(UniqueIdUtil.getSuid());
            field.setSqlId(sqlId);
            this.queryMetafieldManager.create((Object)field);
        }
        List<QueryView> viewList = sqlDef.getViews();
        for (QueryView view : viewList) {
            view.setId(UniqueIdUtil.getSuid());
            this.queryViewDao.insert((Object)view);
        }
        ThreadMsgUtil.addMsg((String)("\u5b9a\u4e49\uff1a" + sqlDef.getName() + "\uff0c\u6210\u529f\u5bfc\u5165!"));
    }
}

