/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.springo.query.manager.impl;

import cn.sexycode.springo.core.base.core.datatrans.ITypeConvert;
import cn.sexycode.springo.core.base.core.datatrans.ResultTransform;
import cn.sexycode.springo.core.base.core.json.JSONArray;
import cn.sexycode.springo.core.base.core.util.BeanUtils;
import cn.sexycode.springo.core.base.core.util.CustomUtil;
import cn.sexycode.springo.core.base.core.util.string.StringUtil;
import cn.sexycode.springo.core.data.db.api.model.PageList;
import cn.sexycode.springo.core.data.db.api.query.QueryOP;
import cn.sexycode.springo.core.data.db.api.sqlbuilder.ISqlBuilderService;
import cn.sexycode.springo.core.data.db.api.sqlbuilder.SqlBuilderModel;
import cn.sexycode.springo.core.data.db.manager.impl.BaseManagerImpl;
import cn.sexycode.springo.core.data.db.query.DefaultQueryFilter;
import cn.sexycode.springo.query.dao.CustomQueryDao;
import cn.sexycode.springo.query.manager.CustomQueryManager;
import cn.sexycode.springo.query.model.CustomQuery;
import com.alibaba.fastjson.JSONObject;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CustomQueryManagerImpl
extends BaseManagerImpl<CustomQuery>
implements CustomQueryManager {
    private static Logger logger = LoggerFactory.getLogger(CustomQueryManager.class);
    @Resource
    private CustomQueryDao customQueryDao;
    @Resource
    private ISqlBuilderService sqlBuilderService;

    @Override
    public PageList getData(CustomQuery customQuery, String queryData, String dsType, int pageNo, int pageSize) {
        String sql = this.getSql(customQuery, queryData, dsType);
        PageList pageList = null;
        Object list = null;
        ResultTransform.transform(pageList, (ITypeConvert)new ITypeConvert(){

            public Object processValue(Object obj) {
                Map map = (Map)obj;
                for (String key : map.keySet()) {
                    if (!Date.class.isAssignableFrom(map.get(key).getClass()) && !java.util.Date.class.isAssignableFrom(map.get(key).getClass())) continue;
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        map.put(key, sdf.format(map.get(key)));
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                }
                return map;
            }
        });
        return pageList;
    }

    private SqlBuilderModel buildSqlBuilderModel(CustomQuery customQuery, String queryData, String dsType) {
        SqlBuilderModel sqlBuilderModel = new SqlBuilderModel();
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtil.isNotEmpty((String)queryData)) {
            JSONArray jArray = JSONArray.parseArray((String)queryData);
            for (int i = 0; i < jArray.size(); ++i) {
                cn.sexycode.springo.core.base.core.json.JSONObject jSONObject = jArray.getJSONObject(i);
                if (!StringUtil.isNotEmpty((String)jSONObject.getString("value"))) continue;
                params.put(jSONObject.getString("key"), jSONObject.getString("value"));
            }
        }
        sqlBuilderModel.setDbType(dsType);
        sqlBuilderModel.setFromName(customQuery.getObjName());
        sqlBuilderModel.setResultField(JSONArray.parseArray((String)customQuery.getResultField()));
        JSONArray conditionField = JSONArray.newJSONArray();
        JSONArray confilJA = JSONArray.parseArray((String)customQuery.getConditionField());
        for (int i = 0; i < confilJA.size(); ++i) {
            cn.sexycode.springo.core.base.core.json.JSONObject jObject = confilJA.getJSONObject(i);
            String field = jObject.getString("field");
            String defaultType = jObject.getString("defaultType");
            String defaultValue = jObject.getString("defaultValue");
            String dbType = jObject.getString("dbType");
            String condition = jObject.getString("condition");
            Object value = null;
            cn.sexycode.springo.core.base.core.json.JSONObject jsonObject = cn.sexycode.springo.core.base.core.json.JSONObject.newJSONObject();
            jsonObject.put((Object)"field", (Object)field);
            jsonObject.put((Object)"op", (Object)condition);
            jsonObject.put((Object)"dbType", (Object)dbType);
            value = CustomUtil.buildValue((String)field, (String)defaultType, (String)defaultValue, params);
            if (BeanUtils.isEmpty((Object)value) || value instanceof String && (StringUtil.isEmpty((String)value.toString()) || value.toString().equals("|"))) continue;
            if (condition.equals(QueryOP.BETWEEN.toString())) {
                value = CustomUtil.handleDateBetweenValue((Object)value);
            }
            jsonObject.put((Object)"value", value);
            conditionField.add((Object)jsonObject);
        }
        sqlBuilderModel.setConditionField(conditionField);
        sqlBuilderModel.setSortField(JSONArray.parseArray((String)customQuery.getSortField()));
        return sqlBuilderModel;
    }

    private String getSql(CustomQuery customQuery, String queryData, String dsType) {
        String sql = "";
        if (customQuery.getSqlBuildType() == 1) {
            HashMap params = new HashMap();
            if (StringUtil.isNotEmpty((String)queryData)) {
                JSONArray json = JSONArray.parseArray((String)queryData);
                HashMap<String, Object> tmp = new HashMap<String, Object>();
                for (Object obj : json) {
                    JSONObject jsonObj = (JSONObject)obj;
                    tmp.put(jsonObj.getString("key"), jsonObj.get((Object)"value"));
                }
                params.put("map", tmp);
                params.putAll(tmp);
            }
        } else {
            SqlBuilderModel model = this.buildSqlBuilderModel(customQuery, queryData, dsType);
            sql = this.sqlBuilderService.getSql(model);
        }
        return sql;
    }

    @Override
    public CustomQuery getByAlias(String alias) {
        this.customQueryDao.testOne();
        DefaultQueryFilter queryFilter = new DefaultQueryFilter();
        queryFilter.addFilter("alias_", (Object)alias, QueryOP.EQUAL);
        return null;
    }
}

