/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.springo.query.manager.impl;

import cn.sexycode.springo.core.base.core.engine.script.GroovyScriptEngine;
import cn.sexycode.springo.core.base.core.json.JSONArray;
import cn.sexycode.springo.core.base.core.json.JSONObject;
import cn.sexycode.springo.core.base.core.util.AppUtil;
import cn.sexycode.springo.core.base.core.util.BeanUtils;
import cn.sexycode.springo.core.base.core.util.JsonUtil;
import cn.sexycode.springo.core.base.core.util.MapUtil;
import cn.sexycode.springo.core.base.core.util.string.StringUtil;
import cn.sexycode.springo.core.data.db.api.model.Page;
import cn.sexycode.springo.core.data.db.api.query.QueryFilter;
import cn.sexycode.springo.core.data.db.api.query.QueryOP;
import cn.sexycode.springo.core.data.db.api.sqlbuilder.ISqlBuilder;
import cn.sexycode.springo.core.data.db.api.sqlbuilder.ISqlBuilderService;
import cn.sexycode.springo.core.data.db.api.sqlbuilder.SqlBuilderModel;
import cn.sexycode.springo.core.data.db.manager.impl.BaseManagerImpl;
import cn.sexycode.springo.core.data.db.mybatis.dao.CommonDao;
import cn.sexycode.springo.core.data.db.query.DefaultPage;
import cn.sexycode.springo.core.data.db.query.DefaultQueryFilter;
import cn.sexycode.springo.query.dao.CustomDialogDao;
import cn.sexycode.springo.query.manager.CustomDialogManager;
import cn.sexycode.springo.query.model.CustomDialog;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="customDialogManager")
public class CustomDialogManagerImpl
extends BaseManagerImpl<CustomDialog>
implements CustomDialogManager {
    @Resource
    CustomDialogDao customDialogDao;
    @Resource
    ISqlBuilderService sqlBuilderService;
    @Resource
    CommonDao commonDao;
    @Resource
    GroovyScriptEngine groovyScriptEngine;

    @Override
    public CustomDialog getByAlias(String alias) {
        return this.customDialogDao.getByAlias(alias);
    }

    @Override
    public List getListData(CustomDialog customDialog, Map<String, Object> param, String dbType) {
        String sql = "";
        if (customDialog.getSqlBuildType() == 1) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("map", param);
            params.putAll(param);
            sql = this.groovyScriptEngine.executeString(customDialog.getDiySql(), params);
        } else {
            SqlBuilderModel model = this.constructSqlBuilderModel(customDialog, param, dbType);
            ISqlBuilder sqlBuilder = this.sqlBuilderService.getSqlBuilder(model);
            sql = sqlBuilder.getSql();
        }
        List list = null;
        if (customDialog.getNeedPage().booleanValue()) {
            int pageNo = Integer.parseInt(MapUtil.getIgnoreCase(param, (String)"page", (Object)"1").toString());
            int pageSize = Integer.parseInt(MapUtil.getIgnoreCase(param, (String)"pageSize", (Object)customDialog.getPageSize()).toString());
            list = this.commonDao.query(sql, (Page)new DefaultPage(pageNo, pageSize));
        } else {
            list = this.commonDao.query(sql);
        }
        for (int i = 0; i < list.size(); ++i) {
            Map m = (Map)list.get(i);
            HashMap tm = new HashMap();
            for (String k : m.keySet()) {
                tm.put(k.toUpperCase(), m.get(k));
            }
            list.set(i, tm);
        }
        return list;
    }

    @Override
    public List geTreetData(CustomDialog customDialog, Map<String, Object> param, String dbType) {
        String sql = this.getTreeSql(customDialog, param, dbType);
        List pageList = this.commonDao.query(sql);
        this.handleIsParent(pageList);
        JSONArray rja = JSONArray.parseArray((String)customDialog.getResultField());
        for (int i = 0; i < rja.size(); ++i) {
            JSONObject jo = rja.getJSONObject(i);
            String comment = jo.getString("comment");
            for (Object obj : pageList) {
                Map map = (Map)obj;
                HashSet set = new HashSet(map.keySet());
                for (String key : set) {
                    if (!key.equalsIgnoreCase(comment)) continue;
                    map.put(comment, map.get(key));
                }
            }
        }
        return pageList;
    }

    private SqlBuilderModel constructSqlBuilderModel(CustomDialog customDialog, Map<String, Object> param, String dbType) {
        JSONArray conditionField = JSONArray.newJSONArray();
        JSONArray conJA = JSONArray.parseArray((String)customDialog.getConditionField());
        for (int i = 0; i < conJA.size(); ++i) {
            JSONObject jo = conJA.getJSONObject(i);
            String fieldName = jo.getString("field");
            String defaultType = jo.getString("defaultType");
            String defaultValue = jo.getString("defaultValue");
            String fdbType = jo.getString("dbType");
            String condition = jo.getString("condition");
            Object value = null;
            value = defaultType.equals("1") ? MapUtil.getIgnoreCase(param, (String)("Q^" + fieldName)) : (defaultType.equals("2") ? defaultValue : (defaultType.equals("3") ? this.groovyScriptEngine.executeObject(defaultValue, param) : MapUtil.getIgnoreCase(param, (String)fieldName)));
            if (BeanUtils.isEmpty((Object)value)) continue;
            JSONObject jsonObject = JSONObject.newJSONObject();
            jsonObject.put((Object)"field", (Object)fieldName);
            jsonObject.put((Object)"op", (Object)condition);
            jsonObject.put((Object)"dbType", (Object)fdbType);
            jsonObject.put((Object)"value", value);
            conditionField.add((Object)jsonObject);
        }
        JSONArray sortField = JSONArray.parseArray((String)customDialog.getSortField());
        JSONObject sortFieldJO = JsonUtil.arrayToObject((JSONArray)sortField, (String)"field");
        String sortFieldStr = MapUtil.getIgnoreCase(param, (String)"sortField", (Object)"").toString();
        String orderSeq = MapUtil.getIgnoreCase(param, (String)"orderSeq", (Object)"").toString();
        if (StringUtil.isNotEmpty((String)sortFieldStr) && StringUtil.isNotEmpty((String)orderSeq)) {
            JSONObject jo = JSONObject.newJSONObject();
            jo.put((Object)"field", (Object)sortFieldStr);
            jo.put((Object)"sortType", (Object)orderSeq);
            sortFieldJO.put((Object)sortFieldStr, (Object)jo);
        }
        SqlBuilderModel model = new SqlBuilderModel();
        model.setFromName(customDialog.getObjName());
        model.setDbType(dbType);
        model.setConditionField(conditionField);
        model.setSortField(JsonUtil.objectToArray((JSONObject)sortFieldJO));
        return model;
    }

    private void handleIsParent(List list) {
        block0: for (Object obj : list) {
            Map map = (Map)obj;
            for (String key : map.keySet()) {
                Object isParent;
                if (key.equals("isParent") || !key.trim().toUpperCase().equals("ISPARENT") || (isParent = map.get(key)) == null) continue;
                if ("true".equals(isParent.toString())) {
                    map.put("isParent", true);
                } else {
                    map.put("isParent", false);
                }
                map.remove(key);
                continue block0;
            }
        }
    }

    private String getTreeSql(CustomDialog customDialog, Map<String, Object> param, String dbType) {
        String sql = "";
        SqlBuilderModel model = this.constructSqlBuilderModel(customDialog, param, dbType);
        JSONObject djo = JSONObject.parseObject((String)customDialog.getDisplayField());
        JSONObject pidJson = JSONObject.newJSONObject();
        String pid = this.getPid(customDialog, param);
        if (StringUtil.isNotEmpty((String)pid)) {
            pidJson.put((Object)"field", djo.get((Object)"pid"));
            pidJson.put((Object)"op", (Object)QueryOP.EQUAL.value());
            pidJson.put((Object)"dbType", (Object)"varchar");
            pidJson.put((Object)"value", (Object)pid);
        } else {
            pidJson.put((Object)"field", djo.get((Object)"pid"));
            pidJson.put((Object)"dbType", (Object)"varchar");
            pidJson.put((Object)"op", (Object)QueryOP.IS_NULL);
        }
        model.getConditionField().add((Object)pidJson);
        sql = this.sqlBuilderService.getSql(model);
        sql = sql.replace(customDialog.getObjName(), customDialog.getObjName() + " o ");
        String isParentSql = ", ( case (select count(*)  from " + customDialog.getObjName() + " p where p." + djo.get((Object)"pid") + "=o." + djo.get((Object)"id") + " and p." + djo.get((Object)"id") + "!=p." + djo.get((Object)"pid") + ") when 0 then 'false' else 'true' end )isParent ";
        String[] strs = sql.split("from");
        strs[0] = strs[0] + ",";
        String str0 = strs[0] + djo.get((Object)"id") + "," + djo.get((Object)"pid") + "," + djo.get((Object)"displayName");
        str0 = str0 + isParentSql;
        sql = str0 + " from " + strs[1];
        return sql;
    }

    private String getPid(CustomDialog customDialog, Map<String, Object> param) {
        JSONObject jo = JSONObject.parseObject((String)customDialog.getDisplayField());
        String id = jo.getString("id");
        String isScript = JsonUtil.getString((JSONObject)jo, (String)"isScript", (String)"false");
        String pvalue = JsonUtil.getString((JSONObject)jo, (String)"pvalue", (String)"");
        String pidVal = MapUtil.getIgnoreCase(param, (String)id, (Object)"").toString();
        if (StringUtil.isEmpty((String)pidVal)) {
            pidVal = isScript != null && isScript.equals("true") ? this.groovyScriptEngine.executeString(pvalue, null).toString() : pvalue;
        }
        return pidVal;
    }

    @Override
    public List getDataByInterface(CustomDialog customDialog, Map<String, Object> param) {
        String beanMethod = customDialog.getObjName();
        if (StringUtil.isEmpty((String)beanMethod)) {
            throw new RuntimeException("\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846\u6570\u636e\u670d\u52a1\u63a5\u53e3\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String[] aryHandler = beanMethod.split("[.]");
        if (aryHandler == null || aryHandler.length != 2) {
            throw new RuntimeException("\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846\u6570\u636e\u670d\u52a1\u63a5\u53e3\u683c\u5f0f\u4e0d\u6b63\u786e\uff01" + beanMethod);
        }
        String beanId = aryHandler[0];
        String method = aryHandler[1];
        Object serviceBean = AppUtil.getBean((String)beanId);
        if (serviceBean == null) {
            throw new RuntimeException(String.format("BeanID %s \u5728Spring\u73af\u5883\u4e2d\u65e0\u6cd5\u627e\u5230", beanId));
        }
        QueryFilter paramInfo = this.getQueryFilter(customDialog, param);
        try {
            Method invokeMethod = serviceBean.getClass().getDeclaredMethod(method, QueryFilter.class);
            return (List)invokeMethod.invoke(serviceBean, paramInfo);
        }
        catch (Exception e) {
            throw new RuntimeException("\u67e5\u8be2\u5f02\u5e38\uff01" + e.getMessage(), e);
        }
    }

    private QueryFilter getQueryFilter(CustomDialog customDialog, Map<String, Object> param) {
        DefaultQueryFilter filter = new DefaultQueryFilter();
        if (customDialog.getNeedPage().booleanValue()) {
            int pageNo = Integer.parseInt(MapUtil.getIgnoreCase(param, (String)"page", (Object)"1").toString());
            int pageSize = Integer.parseInt(MapUtil.getIgnoreCase(param, (String)"pageSize", (Object)customDialog.getPageSize()).toString());
            DefaultPage page = new DefaultPage(pageNo, pageSize);
            filter.setPage((Page)page);
        } else {
            filter.setPage(null);
        }
        JSONArray conJA = JSONArray.parseArray((String)customDialog.getConditionField());
        for (int i = 0; i < conJA.size(); ++i) {
            JSONObject jo = conJA.getJSONObject(i);
            String fieldName = jo.getString("field");
            String defaultType = jo.getString("defaultType");
            String defaultValue = jo.getString("defaultValue");
            String fdbType = JsonUtil.getString((JSONObject)jo, (String)"dbType", (String)"String");
            String condition = jo.getString("condition");
            Object value = null;
            value = defaultType.equals("1") ? MapUtil.getIgnoreCase(param, (String)("Q^" + fieldName)) : (defaultType.equals("2") ? defaultValue : (defaultType.equals("3") ? this.groovyScriptEngine.executeObject(defaultValue, param) : MapUtil.getIgnoreCase(param, (String)fieldName)));
            if (BeanUtils.isEmpty((Object)value)) continue;
            JSONObject jsonObject = JSONObject.newJSONObject();
            jsonObject.put((Object)"field", (Object)fieldName);
            jsonObject.put((Object)"op", (Object)condition);
            jsonObject.put((Object)"dbType", (Object)fdbType);
            jsonObject.put((Object)"value", value);
            QueryOP queryType = QueryOP.getByVal((String)condition);
            if (queryType == null) {
                queryType = QueryOP.EQUAL;
            }
            filter.addFilter(fieldName, value, queryType);
            filter.addParamsFilter(fieldName, value);
        }
        return filter;
    }
}

