/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.springo.gen.boot.autoconfigure;

import cn.sexycode.springo.gen.DataSourceConfig;
import cn.sexycode.springo.gen.GenConfiguration;
import cn.sexycode.springo.gen.GenGlobalConfig;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@EnableAutoConfiguration
@Configuration
@Import(value={GenConfiguration.class})
public class GenAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public GlobalConfig globalConfig() {
        GenGlobalConfig gc = new GenGlobalConfig();
        gc.setOutputDir(System.getProperty("user.dir") + "/gen/src/main/java");
        gc.setAuthor("qzz");
        gc.setOpen(false);
        gc.setServiceImplName("%sManagerImpl");
        gc.setServiceName("%sManager");
        gc.setBaseResultMap(true);
        gc.setMavenStyle(true);
        return gc;
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSourceConfig dataSourceConfig(@Value(value="${spring.datasource.url}") String dbUrl, @Value(value="${spring.datasource.username}") String dbUser, @Value(value="${spring.datasource.password}") String dbPwd) {
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setUrl(dbUrl);
        dsc.setDriverName("com.mysql.cj.jdbc.Driver");
        dsc.setUsername(dbUser);
        dsc.setPassword(dbPwd);
        return dsc;
    }

    @Bean
    @ConditionalOnMissingBean
    public PackageConfig packageConfig() {
        PackageConfig pc = new PackageConfig();
        pc.setService("manager");
        pc.setServiceImpl("manager/impl");
        pc.setEntity("model");
        pc.setMapper("dao");
        pc.setController("rest");
        pc.setParent("cn.sexycode.springo");
        return pc;
    }

    @Bean
    @ConditionalOnMissingBean
    public TemplateConfig templateConfig() {
        TemplateConfig templateConfig = new TemplateConfig();
        templateConfig.setServiceImpl("templates/serviceImpl.java");
        return templateConfig;
    }

    @Bean
    @ConditionalOnMissingBean
    public StrategyConfig strategyConfig(PackageConfig pc) {
        StrategyConfig strategy = new StrategyConfig();
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        strategy.setSuperEntityClass("cn.sexycode.springo.core.base.core.model.BaseModel");
        strategy.setEntityLombokModel(true);
        strategy.setRestControllerStyle(true);
        strategy.setSuperMapperClass("cn.sexycode.springo.core.data.db.dao.impl.BaseMyBatisDao");
        strategy.setSuperControllerClass("cn.sexycode.springo.core.web.BaseController");
        strategy.setSuperServiceClass("cn.sexycode.springo.core.data.db.manager.api.Manager");
        strategy.setSuperServiceImplClass("cn.sexycode.springo.core.data.db.manager.impl.BaseManagerImpl");
        strategy.setSuperEntityColumns(new String[]{"id"});
        strategy.setControllerMappingHyphenStyle(true);
        strategy.setTablePrefix(new String[]{pc.getModuleName() + "_"});
        return strategy;
    }

    @Bean
    @ConditionalOnMissingBean
    public InjectionConfig injectionConfig(final GlobalConfig gc, final PackageConfig pc) {
        InjectionConfig ic = new InjectionConfig(){

            public void initMap() {
            }
        };
        ArrayList<2> focList = new ArrayList<2>();
        focList.add(new FileOutConfig("templates/mapper.xml.ftl"){

            public String outputFile(TableInfo tableInfo) {
                return gc.getOutputDir() + "/src/main/resources/mapper/" + pc.getModuleName() + "/" + tableInfo.getEntityName() + "Mapper" + ".xml";
            }
        });
        ic.setFileOutConfigList(focList);
        return ic;
    }
}

