package cn.sexycode.springo.form.service.impl;


import cn.sexycode.springo.core.base.core.util.BeanUtils;
import cn.sexycode.springo.form.manager.FormManager;
import cn.sexycode.springo.form.model.IForm;
import cn.sexycode.springo.form.service.FormService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * @author qzz
 */
@Service
public class DefaultFormServiceImpl implements FormService {

    @Resource
    private FormManager formManager;

    @Override
    public IForm getByFormKey(String formKey) {
        IForm form = formManager.getMainByFormKey(formKey);
        if (BeanUtils.isNotEmpty(form)) {
            return form;
        }

        return this.getByFormId(formKey);
    }


    @Override
    public IForm getByFormId(String formId) {
        return formManager.get(formId);
    }


    @Override
    public String getFormExportXml(Set<String> formKeys) {
        List<String> id = new ArrayList<String>();
        for (String formKey : formKeys) {
            IForm form = formManager.getMainByFormKey(formKey);
            id.add(form.getId());
        }
//        Map<String, String> map = formManager.exportForms(id, false);

//        return map.get("form.xml");
        return null;
    }


    @Override
    public void importForm(String formXmlStr) {
        try {
            formManager.importByFormXml(formXmlStr);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导入表单失败" + e.getMessage(), e);
        }
    }

}
