package cn.sexycode.springo.form.service;


import cn.sexycode.springo.form.model.IForm;

import java.util.Set;

public interface FormService {

    /**
     * 根据formkey获取表单。
     *
     * @param formKey
     * @return OnlineForm
     */
    IForm getByFormKey(String formKey);

    /**
     * 根据表单ID取得表单对象。
     *
     * @param formId
     * @return OnlineForm
     */
    IForm getByFormId(String formId);

    /**
     * 根据formKey 导出表单
     *
     * @param formKeys
     * @return
     */
    String getFormExportXml(Set<String> formKeys);

    void importForm(String formXmlStr);
}
