package cn.sexycode.springo.form.rest.vo;


import cn.sexycode.springo.core.web.EnumDeserializer;
import cn.sexycode.springo.form.model.FormFiledType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.Map;

/**
 * 对象功能:用户任务表单字段信息表 entity对象
 *
 * @author qinzaizhen
 */
@ToString
public class FormFieldVO {

    /**
     * 字段名称
     */
    @Getter
    @Setter
    private String name;

    /**
     * 字段描述
     */
    @Getter
    @Setter
    private String desc;

    /**
     * 字段的类型
     */
    @Getter
    @Setter
    @JsonDeserialize(using = EnumDeserializer.class)
    protected FormFiledType type;

    /**
     * 分组ID
     */
    @Getter
    @Setter
    private String groupId = "0";

    /**
     * 表单ID
     */
    @Getter
    @Setter
    private String formId;

    /**
     * bo定义ID
     */
    @Getter
    @Setter
    private String boDefId;

    /**
     * 表ID
     */
    @Getter
    @Setter
    private String entId;

    /**
     * BO属性ID
     */
    @Getter
    @Setter
    private String boAttrId;

    /**
     * 运算表达式
     */
    @Getter
    @Setter
    private String calculation;

    /**
     * 控件类型
     */
    @Getter
    @Setter
    private String ctrlType;

    /**
     * 验证规则
     */
    @Setter
    @Getter
    private Map<String, Object> validRule;

    /**
     * 选项
     */
    @Getter
    @Setter
    private Map<String, Object> option;

    /**
     * 排序
     */
    @Getter
    @Setter
    private Integer sn;

    /**
     * 映射对应的实体名称。
     */
    @Getter
    @Setter
    private String entName = "";


}