package cn.sexycode.springo.form.rest;


import cn.sexycode.springo.core.base.api.model.ApiResult;
import cn.sexycode.springo.core.base.core.json.JSONArray;
import cn.sexycode.springo.core.base.core.util.BeanUtils;
import cn.sexycode.springo.core.base.core.util.string.StringUtil;
import cn.sexycode.springo.core.data.db.api.model.PageJson;
import cn.sexycode.springo.core.data.db.api.model.PageList;
import cn.sexycode.springo.core.data.db.api.query.QueryFilter;
import cn.sexycode.springo.core.data.db.id.UniqueIdUtil;
import cn.sexycode.springo.core.web.BaseController;
import cn.sexycode.springo.core.web.util.RequestUtil;
import cn.sexycode.springo.form.manager.FormDefManager;
import cn.sexycode.springo.form.manager.FormTemplateManager;
import cn.sexycode.springo.form.model.FormDef;
import cn.sexycode.springo.form.model.FormTemplate;
import cn.sexycode.springo.form.model.FormType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <pre>
 * 描述：表单模版管理
 * </pre>
 */
@Controller
@RequestMapping("/form/template/")
public class TemplateController extends BaseController {
    @Resource
    FormTemplateManager formTemplateManager;
    @Resource
    FormDefManager formDefManager;

    /**
     * 表单模版列表(分页条件查询)数据
     * TODO方法名称描述
     *
     * @param request
     * @param reponse
     * @return
     * @throws Exception PageJson
     * @since 1.0.0
     */
    @RequestMapping("listJson")
    public @ResponseBody
    PageJson listJson(HttpServletRequest request, HttpServletResponse reponse) throws Exception {
        QueryFilter queryFilter = getQueryFilter(request);
        PageList<FormTemplate> FormTemplateList = (PageList<FormTemplate>) formTemplateManager.query(queryFilter);
        return new PageJson(FormTemplateList);
    }

    /**
     * 编辑表单模版信息页面
     * TODO方法名称描述
     *
     * @param request
     * @param response
     * @return
     * @throws Exception ModelAndView
     * @since 1.0.0
     */
    @RequestMapping("templateEdit")
    public ModelAndView edit(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String preUrl = RequestUtil.getPrePage(request);
        String templateId = RequestUtil.getString(request, "templateId");
        FormTemplate FormTemplate = null;
        if (StringUtil.isNotEmpty(templateId)) {
            FormTemplate = formTemplateManager.get(templateId);
        }
        List<FormTemplate> macroTemplates = formTemplateManager.getAllMacroTemplate();
        return getAutoView().addObject("FormTemplate", FormTemplate).addObject("returnUrl", preUrl)
                .addObject("macroTemplates", macroTemplates);
    }

    /**
     * 表单模版明细页面
     * TODO方法名称描述
     *
     * @param request
     * @param response
     * @return
     * @throws Exception ModelAndView
     * @since 1.0.0
     */
    @RequestMapping("templateGet")
    public ModelAndView get(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String preUrl = RequestUtil.getPrePage(request);
        String templateId = RequestUtil.getString(request, "templateId");
        FormTemplate FormTemplate = null;
        if (StringUtil.isNotEmpty(templateId)) {
            FormTemplate = formTemplateManager.get(templateId);
        }
        return getAutoView().addObject("FormTemplate", FormTemplate).addObject("returnUrl", preUrl);
    }

    @RequestMapping("checkAliasIsExist")
    public @ResponseBody
    boolean checkAliasIsExist(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String alias = RequestUtil.getString(request, "alias");
        if (StringUtil.isEmpty(alias)) return false;
        FormTemplate FormTemplate = formTemplateManager.getByTemplateAlias(alias);
        if (BeanUtils.isEmpty(FormTemplate)) return false;
        return true;
    }

    /**
     * 保存表单模版信息
     * TODO方法名称描述
     *
     * @param request
     * @param response
     * @param FormTemplate
     * @throws Exception void
     * @since 1.0.0
     */
    @RequestMapping("save")
    public void save(HttpServletRequest request, HttpServletResponse response, FormTemplate FormTemplate) throws Exception {
        String resultMsg = null;
        String templateId = FormTemplate.getTemplateId();
        try {
            if (StringUtil.isEmpty(templateId)) {
                FormTemplate.setId(UniqueIdUtil.getSuid());
                FormTemplate.setCanedit(1);
                formTemplateManager.create(FormTemplate);
                resultMsg = "添加表单模版成功";
            } else {
                FormTemplate.setCanedit(1);
                formTemplateManager.update(FormTemplate);
                resultMsg = "更新表单模版成功";
            }
        } catch (Exception e) {
            resultMsg = "对表单模版操作失败";
        }
    }

    /**
     * 批量删除表单模版记录
     * TODO方法名称描述
     *
     * @param request
     * @param response
     * @throws Exception void
     * @since 1.0.0
     */
    @RequestMapping("remove")
    public void remove(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ApiResult message = null;
        try {
            String[] aryIds = RequestUtil.getStringAryByStr(request, "templateId");
            formTemplateManager.removeByIds(aryIds);
            message = new ApiResult(ApiResult.SUCCESS, "删除表单模版成功");
        } catch (Exception e) {
            message = new ApiResult(ApiResult.FAIL, "删除表单模版失败");
        }
    }

    //此方法找不到对应的jsp路径啊
    @RequestMapping("templateSelector")
    public ModelAndView selector(HttpServletRequest request, HttpServletResponse response) throws Exception {
        QueryFilter queryFilter = getQueryFilter(request);
        List<FormTemplate> list = formTemplateManager.query(queryFilter);
        ModelAndView mv = this.getAutoView().addObject("FormTemplateList", list);
        return mv;
    }

    /**
     * 取得初始化模板信息
     *
     * @param request
     * @param response
     * @throws Exception
     */
    @RequestMapping("init")
    public void init(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String preUrl = RequestUtil.getPrePage(request);
        ApiResult message = null;
        try {
            formTemplateManager.initAllTemplate();
            message = new ApiResult(ApiResult.SUCCESS, "初始化表单模板成功!");
        } catch (Exception e) {
            message = new ApiResult(ApiResult.FAIL, "初始化表单模板失败:");
        }
        response.sendRedirect(preUrl);
    }

    /**
     * 将用户自定义模板备份
     *
     * @param request
     * @param response
     * @throws Exception
     */
    @RequestMapping("backUp")
    public void backUp(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String id = RequestUtil.getString(request, "templateId");
        String preUrl = RequestUtil.getPrePage(request);
        ApiResult message = null;
        try {
            formTemplateManager.backUpTemplate(id);
            message = new ApiResult(ApiResult.SUCCESS, "模板备份成功!");
        } catch (Exception e) {
            message = new ApiResult(ApiResult.FAIL, "模板备份失败:");
        }
        response.sendRedirect(preUrl);
    }

    /**
     * 复制模板信息
     *
     * @param request
     * @param response
     * @param template
     * @throws Exception
     */
    @RequestMapping("copyTemplate")
    public void copyTemplate(HttpServletRequest request, HttpServletResponse response, FormTemplate template) throws Exception {
        String id = RequestUtil.getString(request, "templateId");
        FormTemplate formTemplate = formTemplateManager.get(id);
        String name = RequestUtil.getString(request, "newTemplateName");
        String newAlias = RequestUtil.getString(request, "newAlias");
        boolean isExist = formTemplateManager.isExistAlias(newAlias);
//		SysAuditThreadLocalHolder.putParamerter("isExist", isExist);
        if (isExist) {
        } else {
            String newId = UniqueIdUtil.getSuid();
            template.setTemplateId(newId);
            template.setTemplateName(name);
            template.setAlias(newAlias);
            template.setCanedit(1);
            template.setHtml(formTemplate.getHtml());
            template.setMacrotemplateAlias(formTemplate.getMacrotemplateAlias());
            template.setTemplateDesc(formTemplate.getTemplateDesc());
            template.setTemplateType(formTemplate.getTemplateType());
            formTemplateManager.create(template);
        }
    }

    /**
     * 选择模板
     *
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    @RequestMapping("selectTemplate")
    public ModelAndView selectTemplate(HttpServletRequest request,
                                       HttpServletResponse response) throws Exception {
        String defId = RequestUtil.getString(request, "defId");
        int isSimple = RequestUtil.getInt(request, "isSimple", 0);
        String templatesId = RequestUtil.getString(request, "templatesId");
        String formType = RequestUtil.getString(request, "formType", FormType.Type.PC.value());

        ModelAndView mv = this.getAutoView();
        FormDef formDef = formDefManager.get(defId);

        JSONArray fieldList = formDef.getFieldList();

        List<FormTemplate> mainTableTemplates = formTemplateManager.getAllMainTableTemplate(formType.equals(FormType.Type.PC.value()));
        List<FormTemplate> subTableTemplates = formTemplateManager.getAllSubTableTemplate(formType.equals(FormType.Type.PC.value()));


        return mv.addObject("mainTableTemplates", mainTableTemplates)
                .addObject("subTableTemplates", subTableTemplates)
                .addObject("tableList", fieldList)
                .addObject("bpmForm", formDef)
                .addObject("isSimple", isSimple)
                .addObject("templatesId", templatesId);
    }
}
