package cn.sexycode.springo.form.rest;

import cn.sexycode.springo.core.base.api.model.ApiResult;
import cn.sexycode.springo.core.base.core.util.string.StringUtil;
import cn.sexycode.springo.core.data.db.api.model.PageJson;
import cn.sexycode.springo.core.data.db.api.model.PageList;
import cn.sexycode.springo.core.data.db.api.query.QueryFilter;
import cn.sexycode.springo.core.data.db.id.UniqueIdUtil;
import cn.sexycode.springo.core.web.BaseController;
import cn.sexycode.springo.core.web.util.RequestUtil;
import cn.sexycode.springo.form.manager.SelectorDefManager;
import cn.sexycode.springo.form.model.SelectorDef;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * <pre>
 * 描述：控件组合定义管理
 * </pre>
 */
@Controller
@RequestMapping("/form/selectorDef/")
public class SelectorDefController extends BaseController {
    @Resource
    SelectorDefManager selectorDefManager;

    /**
     * 控件组合定义列表(分页条件查询)数据 TODO方法名称描述
     *
     * @param request
     * @param reponse
     * @return
     * @throws Exception PageJson
     */
    @RequestMapping("listJson")
    public @ResponseBody
    PageJson listJson(HttpServletRequest request, HttpServletResponse reponse) throws Exception {
        QueryFilter queryFilter = getQueryFilter(request);
        PageList<SelectorDef> SelectorDefList = (PageList<SelectorDef>) selectorDefManager
                .query(queryFilter);
        return new PageJson(SelectorDefList);
    }


    /**
     * 编辑控件组合定义
     *
     * @param request
     * @param response
     * @return
     * @throws Exception ModelAndView
     */
    @RequestMapping("selectorDefEdit")
    public ModelAndView edit(HttpServletRequest request,
                             HttpServletResponse response) throws Exception {
        String preUrl = RequestUtil.getPrePage(request);
        String id = RequestUtil.getString(request, "id");
        return getAutoView().addObject("id", id)
                .addObject("returnUrl", preUrl);
    }

    /**
     * 获取控件的json数据
     *
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    @SuppressWarnings({"unchecked", "rawtypes"})
    @RequestMapping("selectorData")
    @ResponseBody
    public Object selectorData(HttpServletRequest request, HttpServletResponse response, @RequestBody Map map) throws Exception {
        String id = (String) map.get("id");
        SelectorDef SelectorDef = null;
        if (StringUtil.isNotEmpty(id)) {
            SelectorDef = selectorDefManager.get(id);
        }
        return SelectorDef;
    }

    /**
     * 控件组合定义明细页面 TODO方法名称描述
     *
     * @param request
     * @param response
     * @return
     * @throws Exception ModelAndView
     */
    @RequestMapping("selectorDefGet")
    public ModelAndView get(HttpServletRequest request,
                            HttpServletResponse response) throws Exception {
        String preUrl = RequestUtil.getPrePage(request);
        String id = RequestUtil.getString(request, "id");
        SelectorDef SelectorDef = null;
        if (StringUtil.isNotEmpty(id)) {
            SelectorDef = selectorDefManager.get(id);
        }
        return getAutoView().addObject("SelectorDef", SelectorDef)
                .addObject("returnUrl", preUrl);
    }

    /**
     * @param request
     * @param reponse
     * @return
     */
    @RequestMapping("getById")
    public @ResponseBody
    SelectorDef getById(HttpServletRequest request, HttpServletResponse reponse)
            throws Exception {
        String id = RequestUtil.getString(request, "id");
        SelectorDef SelectorDef = null;
        if (StringUtil.isNotEmpty(id)) {
            SelectorDef = selectorDefManager.get(id);
        }
        return SelectorDef;
    }

    /**
     * @param request
     * @param reponse
     * @return
     */
    @RequestMapping("getByAlias")
    public @ResponseBody
    SelectorDef getByAlias(HttpServletRequest request, HttpServletResponse reponse)
            throws Exception {
        String alias = RequestUtil.getString(request, "alias");
        SelectorDef SelectorDef = null;
        if (StringUtil.isNotEmpty(alias)) {
            SelectorDef = selectorDefManager.getByAlias(alias);
        }
        return SelectorDef;
    }

    /**
     * 保存控件组合定义信息
     *
     * @param request
     * @param response
     * @param SelectorDef
     * @throws Exception void
     */
    @RequestMapping("save")
    @ResponseBody
    public Object save(HttpServletRequest request, HttpServletResponse response, @RequestBody SelectorDef SelectorDef) throws Exception {
        String resultMsg = null;
        String id = SelectorDef.getId();
        try {
            boolean b = selectorDefManager.isExistAlias(SelectorDef.getAlias(), id);
            if (b) {
                return getResult(false, "重复的别名,请检查!");
            }

            if (StringUtil.isEmpty(id)) {
                SelectorDef.setId(UniqueIdUtil.getSuid());
                selectorDefManager.create(SelectorDef);
                resultMsg = "添加控件组合定义成功";
            } else {
                selectorDefManager.update(SelectorDef);
                resultMsg = "更新控件组合定义成功";
            }
            return getResult(true, resultMsg);
        } catch (Exception e) {
            resultMsg = ExceptionUtils.getRootCauseMessage(e);
            return getResult(false, resultMsg);
        }
    }

    /**
     * 批量删除控件组合定义记录 TODO方法名称描述
     *
     * @param request
     * @param response
     * @throws Exception void
     */
    @RequestMapping("remove")
    public void remove(HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        ApiResult message = null;
        try {
            String[] aryIds = RequestUtil.getStringAryByStr(request, "id");
            selectorDefManager.removeByIds(aryIds);
            message = new ApiResult(ApiResult.SUCCESS, "删除控件组合定义成功");
        } catch (Exception e) {
            message = new ApiResult(ApiResult.FAIL, "删除控件组合定义失败");
        }
    }
}
