package cn.sexycode.springo.form.rest;


import cn.sexycode.springo.core.base.api.model.ApiResult;
import cn.sexycode.springo.core.base.core.util.string.StringUtil;
import cn.sexycode.springo.core.data.db.api.model.PageJson;
import cn.sexycode.springo.core.data.db.api.query.QueryFilter;
import cn.sexycode.springo.core.data.db.id.UniqueIdUtil;
import cn.sexycode.springo.core.web.BaseController;
import cn.sexycode.springo.core.web.util.RequestUtil;
import cn.sexycode.springo.form.manager.FormHistoryManager;
import cn.sexycode.springo.form.model.FormHistory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * <pre>
 * 描述：流程表单HTML设计历史记录 控制器类
 * </pre>
 */
@Controller
@RequestMapping("/form/history/")
public class HistoryController extends BaseController {
    @Resource
    FormHistoryManager formHistoryManager;

    /**
     * 流程表单HTML设计历史记录列表(分页条件查询)数据
     * TODO方法名称描述
     *
     * @param request
     * @param reponse
     * @return
     * @throws Exception PageJson
     */
    @RequestMapping("listJson")
    public @ResponseBody
    PageJson listJson(HttpServletRequest request, HttpServletResponse reponse) throws Exception {
        QueryFilter queryFilter = getQueryFilter(request);
        List<FormHistory> list = formHistoryManager.query(queryFilter);
        return new PageJson(list);
    }

    /**
     * 编辑流程表单HTML设计历史记录信息页面
     * TODO方法名称描述
     *
     * @param request
     * @param response
     * @return
     * @throws Exception ModelAndView
     * @since 1.0.0
     */
    @RequestMapping("historyEdit")
    public ModelAndView edit(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String preUrl = RequestUtil.getPrePage(request);
        String id = RequestUtil.getString(request, "id");
        FormHistory FormHistory = null;
        if (StringUtil.isNotEmpty(id)) {
            FormHistory = formHistoryManager.get(id);
        }
        return getAutoView().addObject("FormHistory", FormHistory).addObject("returnUrl", preUrl);
    }

    /**
     * 流程表单HTML设计历史记录明细页面
     *
     * @param request
     * @param response
     * @return
     * @throws Exception ModelAndView
     */
    @RequestMapping("historyGet")
    public ModelAndView get(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String preUrl = RequestUtil.getPrePage(request);
        String id = RequestUtil.getString(request, "id");
        FormHistory FormHistory = null;
        if (StringUtil.isNotEmpty(id)) {
            FormHistory = formHistoryManager.get(id);
        }
        return getAutoView().addObject("FormHistory", FormHistory).addObject("returnUrl", preUrl);
    }

    /**
     * 保存流程表单HTML设计历史记录信息
     * TODO方法名称描述
     *
     * @param request
     * @param response
     * @param FormHistory
     * @throws Exception void
     * @since 1.0.0
     */
    @RequestMapping("save")
    public void save(HttpServletRequest request, HttpServletResponse response, FormHistory FormHistory) throws Exception {
        String resultMsg = null;
        String id = FormHistory.getId();
        try {
            if (StringUtil.isEmpty(id)) {
                FormHistory.setId(UniqueIdUtil.getSuid());
                formHistoryManager.create(FormHistory);
                resultMsg = "添加流程表单HTML设计历史记录成功";
            } else {
                formHistoryManager.update(FormHistory);
                resultMsg = "更新流程表单HTML设计历史记录成功";
            }
        } catch (Exception e) {
            resultMsg = "对流程表单HTML设计历史记录操作失败";
        }
    }

    /**
     * 批量删除流程表单HTML设计历史记录记录
     * TODO方法名称描述
     *
     * @param request
     * @param response
     * @throws Exception void
     * @since 1.0.0
     */
    @RequestMapping("remove")
    public void remove(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ApiResult message = null;
        try {
            String[] aryIds = RequestUtil.getStringAryByStr(request, "id");
            formHistoryManager.removeByIds(aryIds);
            message = new ApiResult(ApiResult.SUCCESS, "删除流程表单HTML设计历史记录成功");
        } catch (Exception e) {
            message = new ApiResult(ApiResult.FAIL, "删除流程表单HTML设计历史记录失败");
        }
    }

    /**
     * 异步返回历史记录
     *
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    @RequestMapping("getByAjax")
    @ResponseBody
    public FormHistory getByAjax(HttpServletRequest request,
                                 HttpServletResponse response) throws Exception {
        String hisId = RequestUtil.getString(request, "hisId");
        FormHistory FormHistory = formHistoryManager.get(hisId);
        return FormHistory;
    }
}
