package cn.sexycode.springo.form.rest;

import cn.sexycode.springo.bo.permission.PermissionUtil;
import cn.sexycode.springo.core.base.api.model.ApiResult;
import cn.sexycode.springo.core.base.core.json.JSONObject;
import cn.sexycode.springo.core.web.BaseController;
import cn.sexycode.springo.core.web.util.RequestUtil;
import cn.sexycode.springo.form.manager.FormDefManager;
import cn.sexycode.springo.form.manager.FormRightManager;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

/**
 * <pre>
 * 描述：表单权限管理
 * </pre>
 */
@Controller
@RequestMapping("/form/rights/")
public class FormRightsController extends BaseController {
    @Resource
    private FormRightManager formRightManager;
    @Resource
    private FormDefManager formDefManager;

    /**
     * 获取表单权限。
     *
     * @return
     */
    @RequestMapping("getPermission")
    @ResponseBody
    public JSONObject getPermission(HttpServletRequest request, HttpServletResponse response) {
        String flowKey = RequestUtil.getString(request, "flowKey");
        String formKey = RequestUtil.getString(request, "formKey");
        String nodeId = RequestUtil.getString(request, "nodeId");
        int type = RequestUtil.getInt(request, "type", 1);
        String parentflowKey = RequestUtil.getString(request, "parentflowKey", "");

        if (type == 1) {
            formRightManager.remove(formKey, flowKey, nodeId, parentflowKey);
        }
        JSONObject json = formRightManager.getPermissionSetting(formKey, flowKey, parentflowKey, nodeId, type, true);

        JSONObject jo = JSONObject.newJSONObject();
        jo.put("json", json);
        jo.put("permissionList", PermissionUtil.getPermissionList("formPermissionCalcList"));
        return jo;
    }


    /**
     * 保存表单权限配置。
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public ApiResult save(HttpServletRequest request, HttpServletResponse response) {

        String flowKey = RequestUtil.getString(request, "flowKey");
        String formKey = RequestUtil.getString(request, "formKey");
        String nodeId = RequestUtil.getString(request, "nodeId");
        int type = RequestUtil.getInt(request, "type", 1);
        String parentflowKey = RequestUtil.getString(request, "parentflowKey", "");
        String permission = RequestUtil.getString(request, "permission", "");
        ApiResult message = new ApiResult(ApiResult.SUCCESS, "保存成功");
        try {
            //权限表中存入表单元数据key。
            formRightManager.save(formKey, flowKey, parentflowKey, nodeId, permission, type);
        } catch (Exception ex) {
            message.setResult(ApiResult.ERROR);
            message.setMessage(ex.getMessage());
        }
        return message;
    }

    /**
     * 获取默认表单权限。
     *
     * @return
     */
    @RequestMapping("getDefaultByFormKey")
    @ResponseBody
    public JSONObject getDefaultByFormKey(HttpServletRequest request, HttpServletResponse response) {
        String formKey = RequestUtil.getString(request, "formKey");
        // 1.为流程权限，2，为实例权限。
        String type = RequestUtil.getString(request, "type", "1");
        boolean isInstance = !"1".equals(type);

        String formMetaKey = formDefManager.getMetaKeyByFormKey(formKey);

        return formRightManager.getDefaultByFormDefKey(formMetaKey, isInstance);
    }

    @RequestMapping("saveSub")
    @ResponseBody
    public void saveSub(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String nodeId = RequestUtil.getString(request, "nodeId");
            String defId = RequestUtil.getString(request, "defId");
//            String parentDefKey = RequestUtil.getString(request, "parentDefKey", BpmConstants.LOCAL);

            Map<String, Object> param = new HashMap<String, Object>();
            /*List<BpmSubTableRight> rights = new ArrayList<BpmSubTableRight>();
            String json = FileUtil.inputStream2String(request.getInputStream());
            JSONObject jobj = JSONObject.parseObject(json);
            for (String key : jobj.keySet()) {
                BpmSubTableRight right = JSONObject.toJavaObject(jobj.getJSONObject(key), BpmSubTableRight.class);
                rights.add(right);
            }
            param.put("list", rights);
            param.put("parentDefKey", parentDefKey);
            BpmDefXmlHandler handler = AppUtil.getBean(SubRightBpmDefXmlHandler.class);
            handler.saveNodeXml(defId, nodeId, param);*/
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping("initSub")
    @ResponseBody
    public Object initSub(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String defId = RequestUtil.getString(request, "defId");
        String nodeId = RequestUtil.getString(request, "nodeId");
        /*String parentDefKey = RequestUtil.getString(request, "parentDefKey", BpmConstants.LOCAL);

        JSONObject json = new JSONObject();
        BpmNodeDef nodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        UserTaskNodeDef utnd = (UserTaskNodeDef) nodeDef;
        for (BpmSubTableRight bsr : utnd.getBpmSubTableRightByParentDefKey(parentDefKey)) {
            json.put(bsr.getTableName(), JSONObject.toJSON(bsr));
        }*/
//        return json;
        return null;
    }

}
