package cn.sexycode.springo.form.rest;


import cn.sexycode.springo.core.base.api.model.ApiResult;
import cn.sexycode.springo.core.base.core.json.JSONArray;
import cn.sexycode.springo.core.base.core.json.JSONObject;
import cn.sexycode.springo.core.base.core.util.BeanUtils;
import cn.sexycode.springo.core.base.core.util.Dom4jUtil;
import cn.sexycode.springo.core.base.core.util.FileUtil;
import cn.sexycode.springo.core.base.core.util.string.StringUtil;
import cn.sexycode.springo.core.data.db.api.model.PageJson;
import cn.sexycode.springo.core.data.db.api.model.PageList;
import cn.sexycode.springo.core.data.db.api.query.QueryFilter;
import cn.sexycode.springo.core.web.BaseController;
import cn.sexycode.springo.core.web.util.RequestUtil;
import cn.sexycode.springo.form.dao.FormDao;
import cn.sexycode.springo.form.dao.FormDefDao;
import cn.sexycode.springo.form.manager.FormDefManager;
import cn.sexycode.springo.form.manager.FormHistoryManager;
import cn.sexycode.springo.form.manager.FormManager;
import cn.sexycode.springo.form.model.FormDef;
import cn.sexycode.springo.form.model.IForm;
import cn.sexycode.springo.form.rest.vo.FormDefVO;
import cn.sexycode.springo.form.service.FormService;
import cn.sexycode.springo.form.util.FormUtil;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 表单管理
 *
 * @author qzz
 */
@RestController
@RequestMapping("/api/form/def/")
public class FormDefController extends BaseController {
    @Resource
    FormManager bpmFormManager;
    @Resource
    FormDefManager formDefManager;
    @Resource
    FormHistoryManager formHistoryManager;
    @Resource
    FormDao formDao;
    @Resource
    FormDefDao formDefDao;
    @Resource
    FormService formService;

    /**
     * 任务表单列表(分页条件查询)数据
     *
     * @return
     * @throws Exception PageJson
     * @since 1.0.0
     */
    @RequestMapping("list")
    public @ResponseBody
    Object listJson(HttpServletRequest request) {
        QueryFilter queryFilter = getQueryFilter(request);
        List<JSONObject> bpmFormDefList = new ArrayList<>();
        PageList<FormDef> list = (PageList<FormDef>) formDefManager.query(queryFilter);
        for (FormDef bpmFormdef : list) {
            JSONObject formJson = JSONObject.newJSONObject();
            formJson.put("desc", bpmFormdef.getName());
            formJson.put("key", bpmFormdef.getDefKey());
            formJson.put("id", bpmFormdef.getId());
            formJson.put("name", bpmFormdef.getName());
            formJson.put("type", bpmFormdef.getType());

            //计算bo对象
            String expand = bpmFormdef.getExpand();
            if (StringUtil.isNotEmpty(expand)) {
                JSONObject expandJson = JSONObject.parseObject(expand);
                if (expandJson.containsKey("boDefList")) {
                    formJson.put("boDefList", expandJson.get("boDefList"));
                }
            }

            bpmFormDefList.add(formJson);
        }
        PageJson pageJson = new PageJson(bpmFormDefList);
        pageJson.setTotal(list.getPageResult().getTotalCount());
        return pageJson;
    }


    /**
     * 编辑表单页面
     *
     * @param request
     * @param response
     * @return
     * @throws Exception ModelAndView
     * @since 1.0.0
     */
    @RequestMapping("formDefEdit")
    public ModelAndView edit(HttpServletRequest request, HttpServletResponse response) {
        String preUrl = RequestUtil.getPrePage(request);
        String id = RequestUtil.getString(request, "id");
        String typeId = RequestUtil.getString(request, "typeId");
        ModelAndView andView = getAutoView();
        if (StringUtil.isNotEmpty(typeId)) {
            andView.addObject("typeId", typeId);
            String typeName = RequestUtil.getString(request, "typeName", "");
            andView.addObject("key", RequestUtil.getString(request, "key"));
            String desc = RequestUtil.getString(request, "description", "");
            String name = RequestUtil.getString(request, "name", "");
            String bos = RequestUtil.getString(request, "bos", "");
            andView.addObject("desc", desc);
            andView.addObject("name", name);
            andView.addObject("bos", bos);
            andView.addObject("type", typeName);
            preUrl = preUrl.replace("addFormStepOne", "list");
        }
        return andView.addObject("formId", id).addObject("returnUrl", preUrl);
    }

    /**
     * 获取表单详情
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping("get")
    @ResponseBody
    public Object get(HttpServletRequest request, HttpServletResponse response) {
        String formId = RequestUtil.getString(request, "id");
        Map<String, Object> map = new HashMap<String, Object>();
        try {
            FormDef bpmForm = null;
            if (StringUtil.isNotEmpty(formId)) {
                bpmForm = formDefManager.get(formId);
            }
            if (BeanUtils.isEmpty(bpmForm)) {
                map.put("result", false);
                map.put("message", "未获取到表单定义");
                return map;
            } else {
                map.put("result", true);
                map.put("bpmForm", bpmForm);
                return map;
            }
        } catch (Exception e) {
            e.printStackTrace();
            map.put("result", false);
            map.put("message", e.getMessage());
            return map;
        }
    }


    @RequestMapping("getFormFieldTree")
    @ResponseBody
    public Object getBoTreeByFormId(HttpServletRequest request, HttpServletResponse response, String defId) {
        FormDef bpmForm = formDefManager.get(defId);
        JSONArray fields = bpmForm.getFieldList();
        return fields;
    }


    /**
     * 保存表单定义
     */
    @RequestMapping(value = "save", method = {RequestMethod.POST, RequestMethod.PUT})
    @ResponseBody
    public ApiResult save(@RequestBody @Validated FormDefVO formDefVO) {

        formDefManager.save(formDefVO);

        return ApiResult.success();
    }


    /**
     * 批量删除表单记录
     *
     * @param request
     * @param response
     * @since 1.0.0
     */
    @RequestMapping("remove")
    public Object remove(HttpServletRequest request, HttpServletResponse response) {
        ApiResult message = null;
        try {
            String[] aryIds = RequestUtil.getStringAryByStr(request, "id");
            //检查是否绑定了表单
            String bpmNames = checkBpmForm(aryIds);
            if (StringUtil.isEmpty(bpmNames)) {
                formDefManager.removeByIds(aryIds);
                message = new ApiResult(ApiResult.SUCCESS, "删除流程任务表单成功");
            } else {
                String msg = "删除失败,表单已被表单使用 formKey：" + bpmNames;
                message = new ApiResult(ApiResult.FAIL, msg);
            }

        } catch (Exception e) {
            message = new ApiResult(ApiResult.FAIL, "删除流程任务表单失败：" + e.getMessage());
        }
        return message;
    }

    /**
     * 删除表单时检查是否绑定了流程
     * 目前是先找表单和业务对象的关系，然后再找业务对象和流程的关系
     *
     * @param aryIds
     * @return
     */
    public String checkBpmForm(String[] aryIds) {
        String formKey = "";
        //多个表单同时删除
        for (String defId : aryIds) {
            List<IForm> form = formDao.getByDefId(defId);
            if (BeanUtils.isNotEmpty(form)) {
                for (IForm f : form) {
                    formKey = f.getFormKey() + ",";
                }
            }

        }

        return formKey;
    }


    /**
     * 加载编辑器设计模式的模板列表
     */
    @RequestMapping("chooseDesignTemplate")
    public ModelAndView chooseDesignTemplate(HttpServletRequest request,
                                             HttpServletResponse response) throws Exception {
        ModelAndView mv = this.getAutoView();
        String subject = RequestUtil.getString(request, "subject");
        Long categoryId = RequestUtil.getLong(request, "categoryId");
        String formDesc = RequestUtil.getString(request, "formDesc");
        int isSimple = RequestUtil.getInt(request, "isSimple", 0);

        String templatePath = FormUtil.getDesignTemplatePath();
        String xml = FileUtil.readFile(templatePath + "designtemps.xml");
        Document document = Dom4jUtil.loadXml(xml);
        Element root = document.getRootElement();
        @SuppressWarnings("unchecked")
        List<Element> list = root.elements();
        String reStr = "[";
        for (Element element : list) {
            String alias = element.attributeValue("alias");
            String name = element.attributeValue("name");
            String templateDesc = element.attributeValue("templateDesc");
            if (!reStr.equals("["))
                reStr += ",";
            reStr += "{name:'" + name + "',alias:'" + alias
                    + "',templateDesc:'" + templateDesc + "'}";
        }
        reStr += "]";
        mv.addObject("subject", subject).addObject("categoryId", categoryId)
                .addObject("formDesc", formDesc).addObject("temps", reStr)
                .addObject("isSimple", isSimple);
        return mv;
    }


    /**
     * 表单定义对话框。
     *
     * @param request
     * @param response
     * @return
     * @throws Exception ModelAndView
     */
    @RequestMapping("boFormDefDialog")
    public ModelAndView dialog(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean isSingle = RequestUtil.getBoolean(request, "isSingle", true);
        String defId = RequestUtil.getString(request, "defId");
        String formType = RequestUtil.getString(request, "formType");
        String topDefKey = RequestUtil.getString(request, "topDefKey", "");
        //src+="&parentDefKey=" + parentDefKey +"&nodeId="+nodeId;
        return getAutoView()
                .addObject("isSingle", isSingle)
                .addObject("formType", formType)
                .addObject("defId", defId)
                .addObject("topDefKey", topDefKey);
    }

    @RequestMapping("checkkeyIsExist")
    public @ResponseBody
    boolean checkAliasIsExist(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String key = RequestUtil.getString(request, "key");
        if (StringUtil.isEmpty(key)) return false;
        FormDef bpmForm = formDefManager.getByKey(key);
        if (BeanUtils.isEmpty(bpmForm)) return false;
        return true;
    }


    @RequestMapping("getOpinionConf")
    @ResponseBody
    public String opinionConf(HttpServletRequest request, HttpServletResponse reponse) throws Exception {
        String id = RequestUtil.getString(request, "id");
        FormDef def = formDefDao.selectById(id);

        String opinionConf = def.getOpinionConf();
        if (StringUtil.isEmpty(opinionConf)) opinionConf = "[]";
        return opinionConf;
    }

    @RequestMapping("opinionConfSave")
    public void opinionConfSave(HttpServletRequest request) throws Exception {
        String id = RequestUtil.getString(request, "id");
        String config = RequestUtil.getString(request, "opinionConf");
        try {
            formDefManager.updateOpinionConf(id, config);
        } catch (Exception e) {
        }
    }

}
