package cn.sexycode.springo.form.rest;

import cn.sexycode.springo.bo.manager.BoDefManager;
import cn.sexycode.springo.core.base.api.model.ApiResult;
import cn.sexycode.springo.core.base.core.aop.Log;
import cn.sexycode.springo.core.base.core.exceptions.BusinessException;
import cn.sexycode.springo.core.base.core.util.BeanUtils;
import cn.sexycode.springo.core.base.core.util.Dom4jUtil;
import cn.sexycode.springo.core.base.core.util.FileUtil;
import cn.sexycode.springo.core.base.core.util.MapBuilder;
import cn.sexycode.springo.core.base.core.util.string.StringUtil;
import cn.sexycode.springo.core.base.core.util.time.DateFormatUtil;
import cn.sexycode.springo.core.base.core.valid.ValidScope;
import cn.sexycode.springo.core.data.db.api.model.PageJson;
import cn.sexycode.springo.core.data.db.api.model.PageList;
import cn.sexycode.springo.core.data.db.id.UniqueIdUtil;
import cn.sexycode.springo.core.web.BaseController;
import cn.sexycode.springo.core.web.util.JsoupUtil;
import cn.sexycode.springo.core.web.util.RequestUtil;
import cn.sexycode.springo.form.dao.FormDefDao;
import cn.sexycode.springo.form.manager.FormHistoryManager;
import cn.sexycode.springo.form.manager.FormManager;
import cn.sexycode.springo.form.manager.FormRightManager;
import cn.sexycode.springo.form.model.FormDef;
import cn.sexycode.springo.form.model.FormStatus;
import cn.sexycode.springo.form.model.FormType;
import cn.sexycode.springo.form.model.IForm;
import cn.sexycode.springo.form.model.impl.Form;
import cn.sexycode.springo.form.rest.vo.FormVO;
import cn.sexycode.springo.form.util.FormUtil;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 * 表单管理
 * <pre>
 * 描述：流程任务表单管理
 * </pre>
 *
 * @author qzz
 */
@RestController
@RequestMapping("/api/form")
public class FormController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(FormController.class);

    @Resource
    FormManager formManager;

    @Resource
    FormHistoryManager formHistoryManager;
    @Resource
    FormDefDao formDefDao;
    @Resource
    BoDefManager bODefManager;
    @Resource
    FormRightManager formRightManager;

    /**
     * 流程任务表单列表(分页条件查询)数据
     *
     * @param request http请求
     * @return list
     */
    @GetMapping("list")
    public @ResponseBody
    @Log
    PageJson listJson(HttpServletRequest request, String formType) {

        List<IForm> formList = formManager.query(getQueryFilter(request).eq("form_type", Optional.ofNullable(formType).orElse(FormType.Type.PC.value())).eq("is_main", true));

        return new PageJson(formList);
    }

    /**
     * 生成表单HTML
     *
     * @return from
     */
    @RequestMapping("edit")
    public Object edit(String defId, String formType,
                       @RequestParam(required = false, value = "id") String formId,
                       String tableNames, String templateAlias) throws Exception {
        IForm form = null;
        if (StringUtil.isNotEmpty(formId)) {
            form = formManager.get(formId);
        } else {
            FormDef formDef = formDefDao.selectById(defId);
            form = new Form();
            form.setDefId(defId);
            form.setName(formDef.getName());
            form.setFormType(FormType.Type.fromValue(Optional.ofNullable(formType).orElse(FormType.Type.PC.value())));
            form.setTypeName(formDef.getType());
            form.setTypeId(formDef.getTypeId());
            form.setMain(true);
            form.setFormVersion(1);
            form.setStatus(FormStatus.Status.DRAFT);

            String html = formManager.getHtml(defId, tableNames, templateAlias);
            html = JsoupUtil.prettyHtml(html);
            form.setFormHtml(html);
        }
        return form;
    }

    /**
     * 保存表单html内容
     *
     * @return 结果
     */

    @RequestMapping("save")
    public Object save(@Validated(ValidScope.AddScope.class) FormVO formVo) {
        Form form = new Form();
        BeanUtils.copyProperties(form, formVo);
        if (StringUtil.isEmpty(formVo.getId())) {
            List<IForm> bpmForm = formManager.getByFormKey(formVo.getFormKey());
            if (BeanUtils.isNotEmpty(bpmForm)) {
                throw new BusinessException("KEY【" + formVo.getFormKey() + "】对应的表单已存在");
            }

            form.setId(UniqueIdUtil.getSuid());
            formManager.create(form);
        } else {
            formManager.update(form);
        }

        return ApiResult.success();

    }

    @GetMapping("versions/list")
    @ResponseBody
    public List<IForm> listVersions(HttpServletRequest request, HttpServletResponse response, @RequestParam String formKey, String formType) {

        return new PageList<>(formManager.query(getQueryFilter(request).eq("form_key", formKey).eq("form_type", formType)));
    }

    /**
     * 表单信息明细页面
     *
     * @param request
     * @param response
     * @throws Exception ModelAndView
     * @since 1.0.0
     */
    @RequestMapping("preview")
    public void preview(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String preUrl = RequestUtil.getPrePage(request);
        ModelAndView modelAndView = getAutoView();
        String id = RequestUtil.getString(request, "id");
        //表单key 对应bpm_form
        String formKey = RequestUtil.getString(request, "formKey");
        //表单定义ID 为BPM_FORM_DEF的主键ID
        String defId = RequestUtil.getString(request, "defId");
        String formType = RequestUtil.getString(request, "formType", FormType.Type.PC.value());

        if (StringUtil.isEmpty(id) && StringUtil.isNotEmpty(formKey)) {
            IForm mainByFormKey = formManager.getMainByFormKey(formKey);
            id = mainByFormKey.getId();
        }

        /*IForm form = new IForm();
        String formHtml = RequestUtil.getString(request, "formHtml");
        if (StringUtil.isNotEmpty(id)) {
            form = formManager.get(id);
            formType = bpmForm.getFormType();
        }
        if (StringUtil.isNotEmpty(bpmForm.getDefId())) {
            defId = bpmForm.getDefId();
        }
        BpmFormDef formDef = formDefDao.get(defId);

        JSONObject permissionConf = null;
        if (StringUtil.isNotEmpty(bpmForm.getFormKey())) {
            permissionConf = formRightManager.getByFormKey(bpmForm.getFormKey(), false);
        } else {
            permissionConf = formRightManager.getDefaultByFormDefKey(formDef.getKey(), false);
        }

        JSONObject permission = formRightManager.calcFormPermission(permissionConf);
        //替换宏变量
        String contextPath = request.getContextPath();
        if (bpmForm != null && StringUtil.isNotEmpty(bpmForm.getFormHtml())) {
            String html = ddjfCustomService.replaceFormMacroByHtml(bpmForm.getFormHtml(), FormMacroVo.buildByCtxAndApplyNO(contextPath, null));
            bpmForm.setFormHtml(html);
        }

        if (StringUtil.isNotEmpty(formHtml)) {
            formHtml = ddjfCustomService.replaceFormMacroByHtml(formHtml, FormMacroVo.buildByCtxAndApplyNO(contextPath, null));
            bpmForm.setFormHtml(formHtml);
        }

        List<String> boCode = formDefDao.getBOCodeByFormId(defId);
        List<BoData> boJson = boDataService.getDataByBoKeys(boCode);
        JSONObject object = BoDataUtil.hanlerData("", boJson);

        if (formType.equals(FormType.MOBILE.value())) {
            modelAndView = new ModelAndView("/form/form/mobilePreview");
        }*/

       /* return modelAndView.addObject("bpmForm", bpmForm)
                .addObject("permission", permission.toString())
                .addObject("data", object.toJSONString())
                .addObject("returnUrl", preUrl);*/
    }

    /**
     * 批量删除表单记录
     *
     * @param request
     * @param response
     * @since 1.0.0
     */
    @RequestMapping("remove")
    public Object remove(HttpServletRequest request, HttpServletResponse response) {
        String[] aryIds = RequestUtil.getStringAryByStr(request, "id");
        formManager.removeByIds(aryIds);

        return new ApiResult(ApiResult.SUCCESS, "删除表单成功");
    }


    /**
     * 加载编辑器设计模式的模板列表
     */
    @GetMapping("chooseDesignTemplate")
    @ResponseBody
    public Object chooseDesignTemplate(HttpServletRequest request,
                                       HttpServletResponse response, String subject,
                                       Long categoryId, String formDesc, @RequestParam(defaultValue = "0") Integer isSimple) throws Exception {
        String templatePath = FormUtil.getDesignTemplatePath();
        String xml = FileUtil.readFile(templatePath + "designtemps.xml");
        Document document = Dom4jUtil.loadXml(xml);
        Element root = document.getRootElement();
        @SuppressWarnings("unchecked")
        List<Element> list = root.elements();
        String reStr = "[";
        for (Element element : list) {
            String alias = element.attributeValue("alias");
            String name = element.attributeValue("name");
            String templateDesc = element.attributeValue("templateDesc");
            if (!reStr.equals("[")) {
                reStr += ",";
                reStr += "{name:'" + name + "',alias:'" + alias + "',templateDesc:'" + templateDesc + "'}";
            }
        }
        reStr += "]";
        return new MapBuilder<>().put("subject", subject).put("categoryId", categoryId).put("formDesc", formDesc).put("temps", reStr).put("isSimple", isSimple).build();
    }

    /**
     * 根据模板产生html。
     *
     * @throws Exception
     */
    @RequestMapping("genByTemplate")
    public void genByTemplate(String tableNames, String templateAlias, String formId, String formDefId) throws Exception {

        // 新建表单的情况没有formId

        /*IForm form = formManager.get(formId);
        if (form != null) formDefId = form.getDefId();

        String html = formManager.getHtml(formDefId, tableNames, templateAlias);

        PrintWriter out = response.getWriter();
        html = JsoupUtil.prettyHtml(html);
*/
        String script = "<script type='text/javascript'>"
                + "function validForm(scope){"
                + " return true;"
                + "}"
                + "</script>";
//        out.println(script + html);
    }


    /**
     * 流程定义对话框。
     *
     * @param request
     * @param response
     * @return
     */
    @GetMapping("dialog/{defId}")
    @ResponseBody
    public Object dialog(HttpServletRequest request, HttpServletResponse response, @RequestParam(defaultValue = "true") Boolean isSingle, @PathVariable(name = "defId") String defId) {

        return new MapBuilder<>().put("isSingle", isSingle).put("defId", defId);
    }


    @PostMapping("version/new")
    @ResponseBody
    public Object newVersion(HttpServletRequest request,
                             HttpServletResponse response, @RequestParam(name = "id") String formId) throws Exception {
        formManager.newVersion(formId);
        return new ApiResult(ApiResult.SUCCESS, "新建表单版本成功!");
    }

    /**
     * 设置默认版本
     */
    @PostMapping("version/default")
    public Object setDefaultVersion(@RequestParam(name = "id") String formId,
                                    @RequestParam String formKey) {
        ApiResult resultObj = new ApiResult(ApiResult.SUCCESS,
                "设置默认版本成功!");
        formManager.setDefaultVersion(formId, formKey);
        return resultObj;
    }

    /**
     * 发布表单
     */
    @PostMapping("publish")
    public Object publish(@RequestParam(name = "id") String formId) {
        formManager.publish(formId);
        return new ApiResult(ApiResult.SUCCESS, "发布版本成功!");
    }

    @RequestMapping("genByField")
    public void genByField(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String defId = RequestUtil.getString(request, "defId");
        String attrId = RequestUtil.getString(request, "attrId");
        String formType = RequestUtil.getString(request, "formType");
        String html = formManager.genByField(defId, attrId, formType);
        html = JsoupUtil.prettyHtml(html);
        PrintWriter out = response.getWriter();
        out.println(html);
    }


    /**
     * <pre>
     * 导出格式为*.zip的BO对象，zip文件包含多个xml文件，每一个xml文件都是一个bo业务对象;
     * <br>
     * zip文件命名为：boDef_yyyyMMddHHmmss.zip;
     * <br>
     * 每个xml文件命名规则为:name_id.xml;
     * <br>
     * 完成后，相关生成的文件都会删除.
     * </pre>
     *
     * @param request
     * @param response
     * @throws Exception
     */
    private final static String ROOT_PATH = "attachFiles" + File.separator + "tempZip"; // 导入和导出的文件操作根目录

    @RequestMapping("exportForm")
    public void exportForm(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String[] ids = RequestUtil.getStringAryByStr(request, "ids");
            if (BeanUtils.isEmpty(ids)) {
                return;
            }
            List<String> idList = Arrays.asList(ids);

//            Map map = formManager.exportForms(idList, true); // 输出xml

            String fileName = "ht_form_" + DateFormatUtil.format(new Date(), "yyyy_MMdd_HHmm");
//            HttpUtil.downLoadFile(request, response, map, fileName);
        } catch (Exception e) {
            e.printStackTrace();
            ApiResult message = new ApiResult(ApiResult.FAIL, "导出失败!");
        }
    }

}
