package cn.sexycode.springo.form.rest;


import cn.sexycode.springo.bo.manager.BoDefManager;
import cn.sexycode.springo.core.base.api.model.ApiResult;
import cn.sexycode.springo.core.base.core.util.string.StringUtil;
import cn.sexycode.springo.core.data.db.id.UniqueIdUtil;
import cn.sexycode.springo.core.web.BaseController;
import cn.sexycode.springo.core.web.util.RequestUtil;
import cn.sexycode.springo.form.dao.FormDefDao;
import cn.sexycode.springo.form.manager.FormBusSetManager;
import cn.sexycode.springo.form.manager.FormDefManager;
import cn.sexycode.springo.form.model.FormBusSet;
import cn.sexycode.springo.form.model.IForm;
import cn.sexycode.springo.form.service.FormService;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 * <pre>
 * 描述：表单业务设置 控制器类
 * </pre>
 */
@Controller
@RequestMapping("/form/formBusSet")
public class FormBusSetController extends BaseController {
    @Resource
    FormBusSetManager formBusSetManager;
    @Resource
    FormService formService;
    @Resource
    FormDefDao formDefDao;
    @Resource
    BoDefManager bODefManager;
    @Resource
    FormDefManager formDefManager;
    @Resource
    BoDefManager boDefManager;


    /**
     * 表单业务设置明细页面
     *
     * @param request
     * @param response
     * @return
     * @throws Exception ModelAndView
     */
    @RequestMapping("getJson")
    @ResponseBody
    public JSONObject getJson(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String formKey = RequestUtil.getString(request, "formKey");
        if (StringUtil.isEmpty(formKey)) {
            return null;
        }
        FormBusSet formBusSet = formBusSetManager.getByFormKey(formKey);

        JSONObject object = new JSONObject();
        object.put("formBusSet", formBusSet);

        //获取BO
        IForm form = (IForm) formService.getByFormKey(formKey);
        /*List<String> boIds = formDefDao.getBODefIdByFormId(form.getDefId());
        if (boIds.size() >= 1) {
            JSONObject boJson = bODefManager.getBoJson(boIds.get(0));
            object.put("boJson", boJson);
        }*/
        return object;
    }

    /**
     * 保存表单业务设置信息
     *
     * @param request
     * @param response
     * @param formBusSet
     * @throws Exception void
     */
    @RequestMapping("save")
    public void save(HttpServletRequest request, HttpServletResponse response, @RequestBody FormBusSet formBusSet) throws Exception {
        String resultMsg = null;
        String id = formBusSet.getId();
        boolean rtn = formBusSetManager.isExist(formBusSet);
        if (rtn) {
            return;
        }

        try {
            if (StringUtil.isEmpty(id)) {
                formBusSet.setId(UniqueIdUtil.getSuid());
                formBusSetManager.create(formBusSet);
                resultMsg = "添加表单业务设置成功";
            } else {
                formBusSetManager.update(formBusSet);
                resultMsg = "更新表单业务设置成功";
            }
        } catch (Exception e) {
            resultMsg = "对表单业务设置操作失败";
        }
    }

    /**
     * 批量删除表单业务设置记录
     *
     * @param request
     * @param response
     * @throws Exception void
     */
    @RequestMapping("remove")
    public void remove(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ApiResult message = null;
        try {
            String[] aryIds = RequestUtil.getStringAryByStr(request, "id");
            formBusSetManager.removeByIds(aryIds);
            message = new ApiResult(ApiResult.SUCCESS, "删除表单业务设置成功");
        } catch (Exception e) {
            message = new ApiResult(ApiResult.FAIL, "删除表单业务设置失败");
        }
    }


    @RequestMapping("createSqlList")
    @ResponseBody
    public ModelAndView treeList(HttpServletRequest request, HttpServletResponse response, String formKey) throws Exception {
        IForm form = (IForm) formService.getByFormKey(formKey);


       /* FormDef formDef = formDefManager.get(form.getDefId());
        List<String> boCode = formDefManager.getBOCodeByFormId(formDef.getId());
        BoDef boDef = boDefManager.getByDefName(boCode.get(0));
        BoEnt boEnt = (BoEnt) boDef.getBoEnt();*/

       /* JSONObject json = new JSONObject();
        json.put("name", form.getName() + "列表");
        json.put("alias", form.getFormKey() + "List");
        json.put("sql", " select * from " + boEnt.getTableName());
        json.put("dsName", boEnt.getDsName().equals("LOCAL") ? "dataSource_Default" : boEnt.getDsName());

        JSONArray array = new JSONArray();
        JSONObject addBtn = new JSONObject();
        addBtn.put("name", "新增");
        addBtn.put("inRow", "0");
        addBtn.put("triggerType", "href");
        addBtn.put("urlPath", "/form/formBus/" + formKey + "/edit");
        array.add(addBtn);

        JSONObject editBtn = new JSONObject();
        editBtn.put("name", "编辑");
        editBtn.put("inRow", "1");
        editBtn.put("triggerType", "href");
        editBtn.put("urlPath", "/form/formBus/" + formKey + "/edit?id={" + boEnt.getPk().toUpperCase() + "}");
        array.add(editBtn);

        JSONObject getBtn = new JSONObject();
        getBtn.put("name", "明细");
        getBtn.put("inRow", "1");
        getBtn.put("triggerType", "href");
        getBtn.put("urlPath", "/form/formBus/" + formKey + "/get?id={" + boEnt.getPk().toUpperCase() + "}");
        array.add(getBtn);

        JSONObject export = new JSONObject();
        export.put("name", "导出");
        export.put("inRow", "0");
        export.put("triggerType", "onclick");
        export.put("urlPath", "exports()");
        array.add(export);

        json.put("buttonDef", array);
        ModelAndView mv = new ModelAndView("/system/query/querySqldefEdit");
        mv.addObject("initModel", json);*/
//        return mv;
        return null;
    }

}
