package cn.sexycode.springo.form.rest;


import cn.sexycode.springo.bo.instance.DataTransform;
import cn.sexycode.springo.bo.manager.BoDefManager;
import cn.sexycode.springo.bo.model.BoData;
import cn.sexycode.springo.core.base.api.model.ApiResult;
import cn.sexycode.springo.core.base.core.engine.script.GroovyScriptEngine;
import cn.sexycode.springo.core.base.core.json.JSONArray;
import cn.sexycode.springo.core.base.core.util.string.StringUtil;
import cn.sexycode.springo.core.web.BaseController;
import cn.sexycode.springo.core.web.util.RequestUtil;
import cn.sexycode.springo.form.manager.FormBusManager;
import cn.sexycode.springo.form.manager.FormBusSetManager;
import cn.sexycode.springo.form.manager.FormDefManager;
import cn.sexycode.springo.form.manager.FormRightManager;
import cn.sexycode.springo.org.util.ContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;


/**
 * <pre>
 * 描述：表单业务保存 控制器类
 * </pre>
 */
@Controller
@RequestMapping("/form/formBus")
public class FormBusController extends BaseController {
    @Resource
    FormBusSetManager formBusSetManager;

    @Resource
    BoDefManager bODefManager;
    @Resource
    FormDefManager formdefManager;
    @Resource
    FormRightManager formRightManager;
    @Resource
    FormBusManager formBusManager;
    @Resource
    DataTransform dataTransform;
    @Resource
    GroovyScriptEngine groovyScriptEngine;

    @Autowired
    private ContextHolder contextHolder;
    /**
     * 表单业务设置明细页面
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping("{formKey}/getList")
    @ResponseBody
    public JSONArray getList(HttpServletRequest request, HttpServletResponse response, @PathVariable(value = "formKey") String formKey) {
        Map<String, Object> param = RequestUtil.getParameterValueMap(request, false, true);

        return formBusManager.getList(formKey, param);
    }

    /**
     * 表单业务设置明细页面
     * 根据主键获取数据
     *
     * @return
     */
    @PostMapping("{formKey}/getData")
    @ResponseBody
    public ApiResult getJson(@PathVariable(value = "formKey") String formKey, String id, @RequestParam(defaultValue = "true") boolean readonly) {
        return ApiResult.success().data(formBusManager.getData(readonly, formKey, id));
    }

    /**
     * 表单业务设置明细页面
     * 根据一堆参数获取数据
     *
     * @param request
     * @return
     */
    @PostMapping("{formKey}/getDataByMap")
    @ResponseBody
    public ApiResult getDataByMap(HttpServletRequest request, @PathVariable(value = "formKey") String formKey, @RequestParam(defaultValue = "true") boolean readonly) {
        Map map = RequestUtil.getParameterValueMap(request, false, false);
        //readonly不是过滤参数
        map.remove("readonly");
        return ApiResult.success().data(formBusManager.getData(readonly, formKey, map));
    }


    /**
     * 编辑页面
     *
     * @param request
     * @param response
     * @param formKey
     * @return
     * @throws Exception
     */
    @RequestMapping("{formKey}/edit")
    @ResponseBody
    public ModelAndView edit(HttpServletRequest request, HttpServletResponse response, @PathVariable(value = "formKey") String formKey) throws Exception {
        String id = RequestUtil.getString(request, "id");
        String parentData = RequestUtil.getString(request, "parentId_");

        ModelAndView mv = new ModelAndView("/form/form/formBusEdit");
        mv.addObject("id", id);
        mv.addObject("formKey", formKey);

        // 树形编辑情况下。添加父ID的值
        if (StringUtil.isNotEmpty(parentData)) {
            String[] parentSet = parentData.split("\\$");
            if (parentSet.length != 2) return mv;
            mv.addObject("parentKey", parentSet[0]);
            mv.addObject("parentVal", parentSet[1]);
        }

        return mv;
    }

    /**
     * 详细页面
     *
     * @param request
     * @param response
     * @param formKey
     * @return
     * @throws Exception
     */
    @RequestMapping("{formKey}/get")
    @ResponseBody
    public ModelAndView get(HttpServletRequest request, HttpServletResponse response, @PathVariable(value = "formKey") String formKey) throws Exception {
        String id = RequestUtil.getString(request, "id");

        ModelAndView mv = new ModelAndView("/form/form/formBusEdit");
        mv.addObject("id", id);
        mv.addObject("formKey", formKey);
        mv.addObject("readonly", true);
        return mv;
    }

    /**
     * 保存表单业务设置信息
     *
     * @param request
     * @param response
     * @throws Exception void
     */
    @RequestMapping("{formKey}/save")
    @ResponseBody
    public void save(HttpServletRequest request, HttpServletResponse response, @PathVariable(value = "formKey") String formKey) throws Exception {
        String json = RequestUtil.getString(request, "json");

        BoData boData = dataTransform.parse(json);
        String saveJsonString = dataTransform.getByData(boData, true);
        try {
            formBusManager.saveData(formKey, saveJsonString);
        } catch (Exception e) {
            if (e.getMessage().length() > 200) {
            } else {
            }
        }
    }


    /**
     * 批量删除表单业务设置记录
     *
     */
    @RequestMapping(value = "{formKey}/remove", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ApiResult remove(@PathVariable(value = "formKey") String formKey, String[] ids) {
        ApiResult message = null;
        try {
            formBusManager.removeByIds(ids, formKey);
            message = new ApiResult(ApiResult.SUCCESS, "删除表单业务设置成功");
        } catch (Exception e) {
            message = new ApiResult(ApiResult.FAIL, "删除表单业务设置失败");
        }

        return message;
    }


}
