package cn.sexycode.springo.form.model;

import cn.sexycode.springo.core.base.api.IModel;

/**
 * 表单接口。
 *
 * @author qzz
 */
public interface IForm extends IModel {

    /**
     * 获取表单KEY
     *
     * @return
     */
    String getFormKey();

    /**
     * 设置表单KEY
     *
     * @param formKey
     */
    void setFormKey(String formKey);

    /**
     * 获取表单名称
     *
     * @return
     */
    String getName();

    /**
     * 设置表单名称
     *
     * @param name
     */
    void setName(String name);

    /**
     * 获取表单分类
     *
     * @return
     */
    FormCategory getCategory();

    /**
     * 设置表单分类
     *
     * @param category
     */
    void setCategory(FormCategory category);

    /**
     * 获取表单值
     * <pre>
     * 不同类型的表单该字段的值不一样：
     * 1、INNER（在线表单）：存放表单html
     * 2、FRAME（以iframe方式嵌入的表单）：存放表单的url
     * </pre>
     *
     * @return
     */
    String getFormHtml();

    /**
     * 设置表单的HTML
     *
     * @param formHtml
     */
    void setFormHtml(String formHtml);

    /**
     * 设置表单类型 pc,mobile。
     *
     * @param formType
     */
    void setFormType(FormType formType);

    /**
     * 获取表单类型。
     *
     * @return
     */
    FormType getFormType();

    void setDescription(String description);

    /**
     * @return 描述
     */
    String getDescription();

    /**
     * 表单定义ID
     */
    void setDefId(String defId);

    String getDefId();

    default FormStatus getStatus() {
        return FormStatus.Status.DRAFT;
    }

    void setStatus(FormStatus status);

    void setMain(boolean main);

    boolean isMain();

    int getFormVersion();

    void setFormVersion(int version);

    String getTypeId();

    void setTypeId(String typeId);

    String getTypeName();

    void setTypeName(String typeName);
}
