package cn.sexycode.springo.form.model;

import lombok.Getter;
import lombok.Setter;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

/**
 * 此类用于表单的导入导出。
 */
@XmlRootElement(name = "bpmForms")
@XmlAccessorType(XmlAccessType.FIELD)
public class FormXml {

    @Getter
    @Setter
    @XmlElement(name = "bpmForm", type = IForm.class)
    private IForm bpmForm;
    @Getter
    @Setter
    @XmlElement(name = "formBusSet", type = FormBusSet.class)
    private FormBusSet formBusSet;
    @Getter
    @Setter
    @XmlElement(name = "bpmFormDef", type = FormDef.class)
    private FormDef bpmFormDef;
    @Getter
    @Setter
    @XmlElement(name = "boCodes")
    private List<String> boCodes;
    @Getter
    @Setter
    @XmlElement(name = "formRights", type = FormRight.class)
    private List<FormRight> formRights = new ArrayList<>();

}
